/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.swing;

import com.chirpcheap.jchirp.swing.CCTableModelEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.cscott.jutil.BinaryHeap;
import net.cscott.jutil.Heap;

public class CCTable
extends JTable {
    int pendingEvents = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CCTable() {
    }

    public CCTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public CCTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public CCTable(TableModel dm) {
        super(dm);
    }

    public CCTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public CCTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public CCTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public void tableChanged(TableModelEvent e) {
        ++this.pendingEvents;
        if (!$assertionsDisabled && this.pendingEvents <= 0) {
            throw new AssertionError();
        }
        EventHandler eh = new EventHandler(e);
        if (this.pendingEvents == 1 && e.getType() != 55) {
            eh.run();
        } else {
            SwingUtilities.invokeLater(eh);
        }
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.getColumnModel().getSelectionModel();
    }

    public ListSelectionModel getRowSelectionModel() {
        return this.getSelectionModel();
    }

    private static void setSelectionFromArray(ListSelectionModel lsm, int[] selected) {
        boolean wasAdjusting = lsm.getValueIsAdjusting();
        if (!wasAdjusting) {
            lsm.setValueIsAdjusting(true);
        }
        lsm.clearSelection();
        Arrays.sort(selected);
        int first = -1;
        int last = -1;
        for (int i = 0; i < selected.length; ++i) {
            int idx = selected[i];
            if (first < 0) {
                first = last = idx;
                continue;
            }
            if (idx == last + 1) {
                last = idx;
                continue;
            }
            lsm.addSelectionInterval(first, last);
            first = last = idx;
        }
        if (first >= 0) {
            lsm.addSelectionInterval(first, last);
        }
        if (!wasAdjusting) {
            lsm.setValueIsAdjusting(false);
        }
    }

    public void createDefaultColumnsFromModel() {
        TableModel tm = this.getModel();
        if (tm == null) {
            return;
        }
        TableColumnModel tcm = this.getColumnModel();
        while (tcm.getColumnCount() > 0) {
            tcm.removeColumn(tcm.getColumn(0));
        }
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            this.addColumn(new CCTableColumn(i));
        }
    }

    private void updateColumn(TableModelEvent e) {
        boolean structureChange;
        boolean bl = structureChange = e.getFirstRow() == -1;
        if (e.getColumn() != -1 && !structureChange) {
            this.updateColumn(e, e.getColumn());
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.updateColumn(e, i);
            }
        }
    }

    private void updateColumn(TableModelEvent e, int col) {
        TableColumn cc = this.getColumnModel().getColumn(col);
        if (cc instanceof CCTableColumn) {
            ((CCTableColumn)cc).updateWith(e);
        }
    }

    static {
        $assertionsDisabled = !CCTable.class.desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CCArrayList<T>
    extends ArrayList<T> {
        CCArrayList(int size) {
            super(size);
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }

    private static class RowNumber {
        final int row;

        RowNumber(int row) {
            this.row = row;
        }

        public int hashCode() {
            return this.row;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RowNumber)) {
                return false;
            }
            return this.row == ((RowNumber)o).row;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellSize
    implements Comparable<CellSize> {
        final int size;

        CellSize(int size) {
            this.size = size;
        }

        @Override
        public int compareTo(CellSize cn) {
            return cn.size - this.size;
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((CellSize)x0);
        }
    }

    class CCTableColumn
    extends TableColumn {
        boolean override;
        Heap<CellSize, RowNumber> sizeHeap;
        CCArrayList<Map.Entry<CellSize, RowNumber>> rowEntries;
        static final /* synthetic */ boolean $assertionsDisabled;

        CCTableColumn(int i) {
            super(i);
            this.override = false;
            this.sizeHeap = null;
        }

        public int getPreferredWidth() {
            if (this.sizeHeap == null) {
                this.initHeap();
            }
            return super.getPreferredWidth();
        }

        public void setPreferredWidth(int width) {
            this.override = true;
            super.setPreferredWidth(width);
        }

        void updateWith(TableModelEvent e) {
            if (this.sizeHeap == null) {
                return;
            }
            int rangeSize = 1 + e.getLastRow() - e.getFirstRow();
            switch (e.getType()) {
                case 1: {
                    this.rowEntries.addAll(1 + e.getFirstRow(), Collections.nCopies(rangeSize, null));
                }
                case 0: {
                    if (e.getFirstRow() == -1 || this.rowEntries.size() < e.getLastRow()) {
                        this.initHeap();
                        return;
                    }
                    for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                        this.updateCellWidth(row);
                    }
                    break;
                }
                case -1: {
                    for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                        this.sizeHeap.delete((Map.Entry)this.rowEntries.get(1 + row));
                    }
                    this.rowEntries.removeRange(1 + e.getFirstRow(), 1 + e.getLastRow());
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.updatePreferredWidth();
        }

        private void initHeap() {
            this.sizeHeap = new BinaryHeap();
            this.rowEntries = new CCArrayList(1 + CCTable.this.getRowCount());
            for (int i = -1; i < CCTable.this.getRowCount(); ++i) {
                this.rowEntries.add(i + 1, null);
                this.updateCellWidth(i);
            }
            this.updatePreferredWidth();
        }

        private void updatePreferredWidth() {
            if (this.override) {
                return;
            }
            int width = 1 + ((CellSize)this.sizeHeap.minimum().getKey()).size;
            if (super.getPreferredWidth() != width) {
                super.setPreferredWidth(width);
            }
        }

        private void updateCellWidth(int row) {
            Object value;
            TableCellRenderer renderer;
            int col = this.getModelIndex();
            if (row == -1) {
                renderer = this.getHeaderRenderer();
                if (renderer == null) {
                    renderer = CCTable.this.getTableHeader().getDefaultRenderer();
                }
                value = this.getHeaderValue();
            } else {
                TableModel model = CCTable.this.getModel();
                renderer = this.getCellRenderer();
                if (renderer == null) {
                    renderer = CCTable.this.getDefaultRenderer(model.getColumnClass(col));
                }
                value = model.getValueAt(row, col);
            }
            Component comp = renderer.getTableCellRendererComponent(CCTable.this, value, false, false, row, col);
            int width = comp.getPreferredSize().width;
            this.updateEntry(row, width);
        }

        private void updateEntry(int row, int width) {
            Map.Entry cellEntry = (Map.Entry)this.rowEntries.get(row + 1);
            if (cellEntry == null) {
                cellEntry = this.sizeHeap.insert((Object)new CellSize(width), (Object)new RowNumber(row));
                this.rowEntries.set(row + 1, cellEntry);
            } else if (((CellSize)cellEntry.getKey()).size != width) {
                this.sizeHeap.updateKey(cellEntry, (Object)new CellSize(width));
            }
        }

        static {
            $assertionsDisabled = !(class$com$chirpcheap$jchirp$swing$CCTable == null ? (class$com$chirpcheap$jchirp$swing$CCTable = CCTable.class$("com.chirpcheap.jchirp.swing.CCTable")) : class$com$chirpcheap$jchirp$swing$CCTable).desiredAssertionStatus();
        }
    }

    private class EventHandler
    implements Runnable {
        final TableModelEvent e;
        static final /* synthetic */ boolean $assertionsDisabled;

        EventHandler(TableModelEvent e) {
            this.e = e;
        }

        public void run() {
            int i;
            --CCTable.this.pendingEvents;
            if (this.e.getType() != 55) {
                CCTable.super.tableChanged(this.e);
                CCTable.this.updateColumn(this.e);
                return;
            }
            if (!$assertionsDisabled && !(this.e instanceof CCTableModelEvent)) {
                throw new AssertionError();
            }
            CCTableModelEvent ee = (CCTableModelEvent)this.e;
            ListSelectionModel rowSelectionModel = CCTable.this.getRowSelectionModel();
            int[] selRows = CCTable.this.getSelectedRows();
            int anchorRow = rowSelectionModel.getAnchorSelectionIndex();
            int leadRow = rowSelectionModel.getLeadSelectionIndex();
            int numMoved = 1 + ee.getLastRow() - ee.getFirstRow();
            TableModelEvent tme = new TableModelEvent(ee.getSource(), Math.min(ee.getFirstRow(), ee.getDestinationRow()), Math.max(ee.getLastRow(), ee.getDestinationRow() + numMoved - 1), ee.getColumn());
            CCTable.super.tableChanged(tme);
            CCTable.this.updateColumn(tme);
            boolean needsUpdate = false;
            for (i = 0; i < selRows.length; ++i) {
                if (ee.getFirstRow() > selRows[i] || selRows[i] > ee.getLastRow()) continue;
                needsUpdate = true;
                break;
            }
            if (!needsUpdate) {
                return;
            }
            for (i = 0; i < selRows.length; ++i) {
                selRows[i] = this.remap(selRows[i], ee);
            }
            CCTable.setSelectionFromArray(rowSelectionModel, selRows);
            rowSelectionModel.setAnchorSelectionIndex(this.remap(anchorRow, ee));
            rowSelectionModel.setLeadSelectionIndex(this.remap(leadRow, ee));
        }

        private int remap(int row, CCTableModelEvent ee) {
            if (ee.getFirstRow() <= row && row <= ee.getLastRow()) {
                return row - ee.getFirstRow() + ee.getDestinationRow();
            }
            int numMoved = 1 + ee.getLastRow() - ee.getFirstRow();
            if (row > ee.getLastRow()) {
                row -= numMoved;
            }
            if (row >= ee.getDestinationRow()) {
                row += numMoved;
            }
            return row;
        }

        static {
            $assertionsDisabled = !(class$com$chirpcheap$jchirp$swing$CCTable == null ? (class$com$chirpcheap$jchirp$swing$CCTable = CCTable.class$("com.chirpcheap.jchirp.swing.CCTable")) : class$com$chirpcheap$jchirp$swing$CCTable).desiredAssertionStatus();
        }
    }
}

