/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.Model;

import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.Cue;
import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.Patch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import javax.swing.event.ChangeEvent;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Show
implements Serializable {
    transient File filename = null;
    transient boolean isDirty = true;
    private CueTime defaultTime;
    private boolean isEditable;
    private final List<Cue> cues = new ArrayList<Cue>();
    public final Patch patch;
    private transient List<CueNumber> cueNumberList;
    transient LinkedList<Listener> listenerList;
    private transient Cue.Listener cueChangeListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$chirpcheap$jchirp$Model$Show;

    Show(Application application) {
        this.defaultTime = application.getDefaultTime();
        this.isEditable = true;
        int numChannels = application.getDefaultNumChannels();
        int numDimmers = application.getDefaultNumDimmers();
        this.cues.clear();
        this.patch = new Patch(numChannels, numDimmers);
        this.isDirty = false;
        this.registerListeners();
        this.demo();
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
    }

    private boolean isValid() {
        if (!($assertionsDisabled || this.defaultTime != null && this.defaultTime.isValid())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.patch != null && this.patch.isValid())) {
            throw new AssertionError();
        }
        Iterator<Cue> it = this.cues.iterator();
        if (it.hasNext()) {
            Cue last = it.next();
            while (it.hasNext()) {
                Cue next = it.next();
                if (!$assertionsDisabled && last.getCueNumber().compareTo(next.getCueNumber()) >= 0) {
                    throw new AssertionError();
                }
                last = next;
            }
        }
        return true;
    }

    private void demo() {
        short[] levels1 = new short[this.patch.getNumChannels()];
        short[] levels2 = new short[this.patch.getNumChannels()];
        short[] levels3 = new short[this.patch.getNumChannels()];
        CueTime zero = new CueTime(0);
        CueTime two = new CueTime(20);
        CueTime three = new CueTime(30);
        CueTime five = new CueTime(50);
        for (int i = 0; i < this.patch.getNumChannels(); ++i) {
            levels1[i] = (short)Math.round(Math.random() * 100.0);
            levels3[i] = (short)Math.round(Math.random() * 100.0);
        }
        this.addCue(new CueNumber(10), zero, zero, zero, null, zero, levels1, "Preset");
        this.addCue(new CueNumber(20), two, three, zero, new CueNumber(30), five, levels2, "Blackout");
        this.addCue(new CueNumber(30), two, two, zero, null, zero, levels3, "Scene 1");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.registerListeners();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    void setDirty(boolean isDirty) {
        if (this.isDirty == isDirty) {
            return;
        }
        this.isDirty = isDirty;
        this.fireShowDirtyChanged();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        if (this.isEditable == isEditable) {
            return;
        }
        this.isEditable = isEditable;
        this.fireShowEditableChanged();
    }

    public File getFilename() {
        return this.filename;
    }

    public void setFilename(File filename) {
        this.filename = filename;
        this.fireShowFilenameChanged();
    }

    public CueTime getDefaultTime() {
        return this.defaultTime;
    }

    public void setDefaultTime(CueTime defaultTime) {
        if (!$assertionsDisabled && defaultTime == null) {
            throw new AssertionError();
        }
        if (this.defaultTime.equals(defaultTime)) {
            return;
        }
        this.defaultTime = defaultTime;
        this.fireShowDefaultTimeChanged();
    }

    public int getNumCues() {
        return this.cues.size();
    }

    public Cue getCue(int cueIndex) {
        return this.cues.get(cueIndex);
    }

    public Cue getCue(CueNumber cn) {
        int cueIndex = this.getCueNumberList().indexOf(cn);
        return cueIndex < 0 ? null : this.getCue(cueIndex);
    }

    Cue getCueBefore(CueNumber cn) {
        int cueIndex = this.getCueNumberList().indexOf(cn);
        return cueIndex < 1 ? null : this.getCue(cueIndex - 1);
    }

    Cue getCueAfter(CueNumber cn) {
        int cueIndex = this.getCueNumberList().indexOf(cn);
        return cueIndex < 0 || cueIndex + 1 >= this.cues.size() ? null : this.getCue(cueIndex + 1);
    }

    private List<CueNumber> getCueNumberList() {
        if (this.cueNumberList == null) {
            this.cueNumberList = new CueNumberList();
        }
        return this.cueNumberList;
    }

    public void addCue(CueNumber cueNumber, CueTime upTime, CueTime downTime, CueTime delayTime, CueNumber linkNumber, CueTime linkTime, short[] levels, String notes) {
        int cueIndex = Collections.binarySearch(this.getCueNumberList(), cueNumber);
        if (cueIndex < 0) {
            cueIndex = -(cueIndex + 1);
            Cue newCue = new Cue(cueNumber, upTime, downTime, delayTime, linkNumber, linkTime, levels, notes, this.patch);
            this.cues.add(cueIndex, newCue);
            newCue.addCueListener(this.getCueChangeListener());
            this.fireShowCueAdded(newCue, cueIndex);
        } else {
            Cue oldCue = this.cues.get(cueIndex);
            if (!$assertionsDisabled && !oldCue.getCueNumber().equals(cueNumber)) {
                throw new AssertionError();
            }
            oldCue.setUpTime(upTime);
            oldCue.setDownTime(downTime);
            oldCue.setDelayTime(delayTime);
            oldCue.setLinkNumber(linkNumber);
            oldCue.setLinkTime(linkTime);
            oldCue.setLevels(0, levels);
            oldCue.setNotes(notes);
            if (!$assertionsDisabled && oldCue.patch != this.patch) {
                throw new AssertionError();
            }
        }
    }

    public void removeCue(CueNumber cn) {
        int cueIndex = this.getCueNumberList().indexOf(cn);
        if (!$assertionsDisabled && cueIndex < 0) {
            throw new AssertionError();
        }
        this.removeCue(cueIndex);
    }

    public void removeCue(int cueIndex) {
        if (!($assertionsDisabled || cueIndex >= 0 && cueIndex < this.cues.size())) {
            throw new AssertionError();
        }
        Cue oldCue = this.cues.remove(cueIndex);
        oldCue.removeCueListener(this.getCueChangeListener());
        this.fireShowCueRemoved(oldCue, cueIndex);
    }

    public void renumberCue(CueNumber oldCueNumber, CueNumber newCueNumber) {
        int oldIndex = this.getCueNumberList().indexOf(oldCueNumber);
        if (!$assertionsDisabled && oldIndex < 0) {
            throw new AssertionError((Object)"old cue number not present");
        }
        Cue cue = this.cues.remove(oldIndex);
        int newIndex = Collections.binarySearch(this.getCueNumberList(), newCueNumber);
        if (!$assertionsDisabled && newIndex >= 0) {
            throw new AssertionError((Object)"new cue number already present");
        }
        newIndex = -(newIndex + 1);
        this.cues.add(newIndex, cue);
        cue.setCueNumber(newCueNumber);
        this.fireShowCueRenumbered(cue, newIndex, oldIndex);
    }

    static Show load(File filename) {
        Object o;
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            o = ois.readObject();
            ois.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        if (!(o instanceof Show)) {
            return null;
        }
        Show show = (Show)o;
        show.filename = filename;
        show.isDirty = false;
        return show;
    }

    boolean save(File filename) {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        this.setFilename(filename);
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            this.setDirty(false);
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void addShowListener(Listener l) {
        if (this.listenerList == null) {
            this.listenerList = new LinkedList();
        }
        this.listenerList.add(0, l);
    }

    public void removeShowListener(Listener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(l);
    }

    protected void fireShowAncestorChanged() {
        this.fireShowAncestorChanged(null);
    }

    protected void fireShowAncestorChanged(ChangeEvent e) {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = e;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).showAncestorChanged(changeEvent);
        }
    }

    protected void fireShowFilenameChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).showFilenameChanged(changeEvent);
        }
    }

    protected void fireShowDirtyChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).showDirtyChanged(changeEvent);
        }
    }

    protected void fireShowEditableChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).showEditableChanged(changeEvent);
        }
    }

    protected void fireShowDefaultTimeChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).showDefaultTimeChanged(changeEvent);
        }
    }

    protected void fireShowCueModified(Cue cue, int cueIndex, Cue.ChangeEvent cce) {
        if (this.listenerList == null) {
            return;
        }
        CueListChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new CueListChangeEvent(this, cue, cueIndex, cce);
            }
            ((Listener)it.next()).showCueModified(changeEvent);
        }
    }

    protected void fireShowCueAdded(Cue cue, int cueIndex) {
        if (this.listenerList == null) {
            return;
        }
        CueListChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new CueListChangeEvent(this, cue, cueIndex, null);
            }
            ((Listener)it.next()).showCueAdded(changeEvent);
        }
    }

    protected void fireShowCueRemoved(Cue cue, int cueIndex) {
        if (this.listenerList == null) {
            return;
        }
        CueListChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new CueListChangeEvent(this, cue, cueIndex, null);
            }
            ((Listener)it.next()).showCueRemoved(changeEvent);
        }
    }

    protected void fireShowCueRenumbered(Cue cue, int cueIndex, int oldCueIndex) {
        if (this.listenerList == null) {
            return;
        }
        CueListChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new CueListChangeEvent(this, cue, cueIndex, oldCueIndex, null);
            }
            ((Listener)it.next()).showCueRenumbered(changeEvent);
        }
    }

    private Cue.Listener getCueChangeListener() {
        if (this.cueChangeListener == null) {
            this.cueChangeListener = new Cue.Listener(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void cueLevelsChanged(Cue.ChangeEvent e) {
                    this.doit(e);
                }

                public void cueInfoChanged(Cue.ChangeEvent e) {
                    this.doit(e);
                }

                private void doit(Cue.ChangeEvent e) {
                    int cueIndex = Show.this.getCueNumberList().indexOf(e.getSource().getCueNumber());
                    if (!$assertionsDisabled && cueIndex < 0) {
                        throw new AssertionError();
                    }
                    Show.this.fireShowCueModified(e.getSource(), cueIndex, e);
                }

                static {
                    $assertionsDisabled = !(class$com$chirpcheap$jchirp$Model$Show == null ? (class$com$chirpcheap$jchirp$Model$Show = Show.class$("com.chirpcheap.jchirp.Model.Show")) : class$com$chirpcheap$jchirp$Model$Show).desiredAssertionStatus();
                }
            };
        }
        if (!$assertionsDisabled && this.cueChangeListener == null) {
            throw new AssertionError();
        }
        return this.cueChangeListener;
    }

    private void registerListeners() {
        this.addShowListener(new Listener(){

            public void showAncestorChanged(ChangeEvent e) {
                Show.this.patch.firePatchAncestorChanged(e);
            }

            public void showDirtyChanged(ChangeEvent e) {
            }

            public void showFilenameChanged(ChangeEvent e) {
                this.dirty();
            }

            public void showEditableChanged(ChangeEvent e) {
                this.dirty();
            }

            public void showDefaultTimeChanged(ChangeEvent e) {
                this.dirty();
            }

            public void showCueAdded(CueListChangeEvent event) {
                this.dirty();
            }

            public void showCueModified(CueListChangeEvent event) {
                this.dirty();
            }

            public void showCueRemoved(CueListChangeEvent event) {
                this.dirty();
            }

            public void showCueRenumbered(CueListChangeEvent event) {
                this.dirty();
            }

            private void dirty() {
                Show.this.setDirty(true);
            }
        });
        this.patch.addPatchListener(new Patch.Listener(){

            public void patchAncestorChanged(ChangeEvent e) {
            }

            public void patchNumChannelsChanged(ChangeEvent e) {
                this.dirty();
            }

            public void patchNumDimmersChanged(ChangeEvent e) {
                this.dirty();
            }

            public void patchChannelChanged(Patch.ChannelChangeEvent e) {
                this.dirty();
            }

            public void patchDimmerChanged(Patch.DimmerChangeEvent e) {
                this.dirty();
            }

            private void dirty() {
                Show.this.setDirty(true);
            }
        });
        Iterator<Cue> it = this.cues.iterator();
        while (it.hasNext()) {
            it.next().addCueListener(this.getCueChangeListener());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$chirpcheap$jchirp$Model$Show == null ? (class$com$chirpcheap$jchirp$Model$Show = Show.class$("com.chirpcheap.jchirp.Model.Show")) : class$com$chirpcheap$jchirp$Model$Show).desiredAssertionStatus();
    }

    public static class CueListChangeEvent
    extends ChangeEvent {
        final Cue cue;
        final int cueIndex;
        final int oldCueIndex;
        final Cue.ChangeEvent changeEvent;

        CueListChangeEvent(Show source, Cue cue, int cueIndex, Cue.ChangeEvent changeEvent) {
            this(source, cue, cueIndex, -1, changeEvent);
        }

        CueListChangeEvent(Show source, Cue cue, int cueIndex, int oldCueIndex, Cue.ChangeEvent changeEvent) {
            super(source);
            this.cue = cue;
            this.cueIndex = cueIndex;
            this.changeEvent = changeEvent;
            this.oldCueIndex = oldCueIndex;
        }

        public Show getSource() {
            return (Show)super.getSource();
        }

        public Cue getCue() {
            return this.cue;
        }

        public int getCueIndex() {
            return this.cueIndex;
        }

        public int getOldCueIndex() {
            return this.oldCueIndex;
        }

        public Cue.ChangeEvent getChangeEvent() {
            return this.changeEvent;
        }

        public /* synthetic */ Object getSource() {
            return this.getSource();
        }
    }

    public static abstract class Adapter
    implements Listener {
        public void showAncestorChanged(ChangeEvent event) {
        }

        public void showFilenameChanged(ChangeEvent event) {
        }

        public void showDirtyChanged(ChangeEvent event) {
        }

        public void showEditableChanged(ChangeEvent event) {
        }

        public void showDefaultTimeChanged(ChangeEvent event) {
        }

        public void showCueAdded(CueListChangeEvent event) {
        }

        public void showCueModified(CueListChangeEvent event) {
        }

        public void showCueRemoved(CueListChangeEvent event) {
        }

        public void showCueRenumbered(CueListChangeEvent event) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void showAncestorChanged(ChangeEvent var1);

        public void showFilenameChanged(ChangeEvent var1);

        public void showDirtyChanged(ChangeEvent var1);

        public void showEditableChanged(ChangeEvent var1);

        public void showDefaultTimeChanged(ChangeEvent var1);

        public void showCueAdded(CueListChangeEvent var1);

        public void showCueModified(CueListChangeEvent var1);

        public void showCueRemoved(CueListChangeEvent var1);

        public void showCueRenumbered(CueListChangeEvent var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CueNumberList
    extends AbstractList<CueNumber>
    implements RandomAccess {
        private CueNumberList() {
        }

        @Override
        public CueNumber get(int i) {
            return ((Cue)Show.this.cues.get(i)).getCueNumber();
        }

        @Override
        public int size() {
            return Show.this.cues.size();
        }

        public int indexOf(CueNumber cn) {
            int idx = Collections.binarySearch(this, cn);
            return idx < 0 ? -1 : idx;
        }

        @Override
        public int indexOf(Object o) {
            try {
                return this.indexOf((CueNumber)o);
            }
            catch (ClassCastException e) {
                return -1;
            }
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public /* synthetic */ Object remove(int x0) {
            return super.remove(x0);
        }

        @Override
        public /* synthetic */ void add(int x0, Object x1) {
            super.add(x0, (CueNumber)x1);
        }

        @Override
        public /* synthetic */ Object set(int x0, Object x1) {
            return super.set(x0, (CueNumber)x1);
        }

        @Override
        public /* synthetic */ Object get(int x0) {
            return this.get(x0);
        }

        @Override
        public /* synthetic */ boolean add(Object x0) {
            return super.add((CueNumber)x0);
        }
    }
}

