/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.Model;

import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.Cue;
import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.Show;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;

public class RunState {
    public final Show show;
    Cue currentCue;
    Cue previousCue;
    Cue nextCue;
    float progress;
    final List<CapturedChannel> capturedChannels = new ArrayList<CapturedChannel>();
    final LinkedList<Listener> listenerList = new LinkedList();
    private final Cue.Listener cueRenumberListener;

    RunState(Show show) {
        this(show, null);
    }

    RunState(Show show, RunState previous) {
        this.addRunStateListener(new Adapter(){

            public void runStateAncestorChanged(ChangeEvent e) {
                RunState.this.show.fireShowAncestorChanged(e);
            }
        });
        this.cueRenumberListener = new Cue.Adapter(){

            public void cueInfoChanged(Cue.ChangeEvent e) {
                if (e.getSource() == RunState.this.currentCue && e.getType() == 1 && RunState.this.nextCue == null) {
                    RunState.this.fireRunStateFaderChanged();
                }
            }
        };
        this.show = show;
        Cue cue = this.nextCue = show.getNumCues() > 0 ? show.getCue(0) : null;
        if (previous == null) {
            this.previousCue = null;
            this.currentCue = null;
            this.progress = 1.0f;
            this.capturedChannels.clear();
        } else {
            this.previousCue = previous.previousCue;
            this.currentCue = previous.currentCue;
            this.progress = previous.progress;
            this.capturedChannels.addAll(previous.capturedChannels);
        }
    }

    RunState(Application application) {
        this(new Show(application), null);
    }

    public Cue getCurrentCue() {
        return this.currentCue;
    }

    public Cue getNextCue() {
        if (this.nextCue != null) {
            return this.nextCue;
        }
        if (this.currentCue == null) {
            return null;
        }
        return this.show.getCueAfter(this.currentCue.getCueNumber());
    }

    public float getProgress() {
        return this.progress;
    }

    public short[] getStageChannelLevels() {
        throw new RuntimeException("unimplemented");
    }

    public void setCurrentCue(CueNumber cn) {
        Cue oldCurCue = this.currentCue;
        if (oldCurCue != null) {
            oldCurCue.removeCueListener(this.cueRenumberListener);
        }
        Cue cue = this.currentCue = cn == null ? null : this.show.getCue(cn);
        if (this.currentCue != null) {
            this.currentCue.addCueListener(this.cueRenumberListener);
        }
        if (oldCurCue == this.currentCue) {
            return;
        }
        this.fireRunStateFaderChanged();
    }

    public void setNextCue(CueNumber cn) {
        Cue oldNextCue = this.nextCue;
        Cue cue = this.nextCue = cn == null ? null : this.show.getCue(cn);
        if (this.nextCue == oldNextCue) {
            return;
        }
        this.fireRunStateFaderChanged();
    }

    public void go() {
        if (this.getNextCue() == null) {
            return;
        }
        this.currentCue = this.getNextCue();
        this.nextCue = null;
        this.progress = 0.0f;
        this.fireRunStateFaderChanged();
        this.fireRunStateCueProgress();
    }

    public void halt() {
        throw new RuntimeException("unimplemented");
    }

    public void back() {
        if (this.currentCue == null) {
            return;
        }
        Cue prev = this.show.getCueBefore(this.currentCue.getCueNumber());
        if (prev == null) {
            return;
        }
        this.setNextCue(prev.getCueNumber());
        this.go();
    }

    public void addRunStateListener(Listener l) {
        this.listenerList.add(0, l);
    }

    public void removeRunStateListener(Listener l) {
        this.listenerList.remove(l);
    }

    protected void fireRunStateAncestorChanged() {
        this.fireRunStateAncestorChanged(null);
    }

    protected void fireRunStateAncestorChanged(ChangeEvent e) {
        ChangeEvent changeEvent = e;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).runStateAncestorChanged(changeEvent);
        }
    }

    protected void fireRunStateFaderChanged() {
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).runStateFaderChanged(changeEvent);
        }
    }

    protected void fireRunStateCueProgress() {
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).runStateCueProgress(changeEvent);
        }
    }

    public static abstract class Adapter
    implements Listener {
        public void runStateAncestorChanged(ChangeEvent event) {
        }

        public void runStateFaderChanged(ChangeEvent event) {
        }

        public void runStateCueProgress(ChangeEvent event) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void runStateAncestorChanged(ChangeEvent var1);

        public void runStateFaderChanged(ChangeEvent var1);

        public void runStateCueProgress(ChangeEvent var1);
    }

    static class CapturedChannel {
        int channel;
        int level;

        CapturedChannel() {
        }
    }
}

