/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.Model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch
implements Serializable {
    List<ChannelAssignment> channels = new ArrayList<ChannelAssignment>();
    List<DimmerAssignment> dimmers = new ArrayList<DimmerAssignment>();
    transient LinkedList<Listener> listenerList;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$chirpcheap$jchirp$Model$Patch;

    public Patch(int numChannels, int numDimmers) {
        this.channels = new ArrayList<ChannelAssignment>(numChannels);
        this.dimmers = new ArrayList<DimmerAssignment>(numDimmers);
        this.setNumChannels(numChannels);
        this.setNumDimmers(numDimmers);
        if (!$assertionsDisabled && this.getNumChannels() != numChannels) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getNumDimmers() != numDimmers) {
            throw new AssertionError();
        }
        this.registerListeners();
        this.makeOneToOne();
    }

    boolean isValid() {
        for (int chan = 0; chan < this.getNumChannels(); ++chan) {
            for (int dim : this.getDimmersForChannel(chan)) {
                if (!$assertionsDisabled && !this.getChannelsForDimmer(dim).contains(new Integer(chan))) {
                    throw new AssertionError();
                }
            }
        }
        for (int dim = 0; dim < this.getNumDimmers(); ++dim) {
            for (int chan : this.getChannelsForDimmer(dim)) {
                if (!$assertionsDisabled && !this.getDimmersForChannel(chan).contains(new Integer(dim))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.registerListeners();
    }

    public void makeOneToOne() {
        int i;
        for (i = 0; i < Math.min(this.getNumChannels(), this.getNumDimmers()); ++i) {
            Set<Integer> dimmers = this.getDimmersForChannel(i);
            dimmers.clear();
            dimmers.add(new Integer(i));
        }
        for (i = this.getNumChannels(); i < this.getNumDimmers(); ++i) {
            this.getChannelsForDimmer(i).clear();
        }
        for (i = this.getNumDimmers(); i < this.getNumChannels(); ++i) {
            this.getDimmersForChannel(i).clear();
        }
    }

    public int getNumChannels() {
        return this.channels.size();
    }

    public int getNumDimmers() {
        return this.dimmers.size();
    }

    public void setNumChannels(int numChannels) {
        int i;
        int oldChannels = this.getNumChannels();
        if (oldChannels == numChannels) {
            return;
        }
        for (i = oldChannels; i < numChannels; ++i) {
            this.channels.add(new ChannelAssignment());
        }
        for (i = oldChannels - 1; i >= numChannels; --i) {
            this.getDimmersForChannel(i).clear();
            this.channels.remove(i);
        }
        if (!$assertionsDisabled && this.getNumChannels() != numChannels) {
            throw new AssertionError();
        }
        this.firePatchNumChannelsChanged();
    }

    public void setNumDimmers(int numDimmers) {
        int i;
        int oldDimmers = this.getNumDimmers();
        if (oldDimmers == numDimmers) {
            return;
        }
        for (i = oldDimmers; i < numDimmers; ++i) {
            this.dimmers.add(new DimmerAssignment());
        }
        for (i = oldDimmers - 1; i >= numDimmers; --i) {
            this.getChannelsForDimmer(i).clear();
            this.dimmers.remove(i);
        }
        if (!$assertionsDisabled && this.getNumDimmers() != numDimmers) {
            throw new AssertionError();
        }
        this.firePatchNumDimmersChanged();
    }

    public String getChannelName(int channel) {
        if (!$assertionsDisabled && channel >= this.getNumChannels()) {
            throw new AssertionError();
        }
        String name = this.channels.get((int)channel).channelName;
        return name == null ? "" : name;
    }

    public void setChannelName(int channel, String name) {
        this.channels.get((int)channel).channelName = name;
        this.firePatchChannelChanged(channel);
    }

    public Set<Integer> getDimmersForChannel(final int channel) {
        final List<Integer> dim4chan = this.channels.get((int)channel).dimmers;
        return new AbstractSet<Integer>(){

            @Override
            public int size() {
                return dim4chan.size();
            }

            @Override
            public boolean add(Integer element) {
                if (dim4chan.contains(element)) {
                    return false;
                }
                int dimmer = element;
                Patch.this.dimmers.get((int)dimmer).channels.add(new Integer(channel));
                dim4chan.add(element);
                Patch.this.firePatchChannelChanged(channel);
                Patch.this.firePatchDimmerChanged(dimmer);
                return true;
            }

            @Override
            public Iterator<Integer> iterator() {
                Iterator it = dim4chan.iterator();
                return new Iterator<Integer>(){
                    int dimmer;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public Integer next() {
                        Integer i = (Integer)this.val$it.next();
                        this.dimmer = i;
                        return i;
                    }

                    public void remove() {
                        this.val$it.remove();
                        1.access$100(this.this$1).dimmers.get((int)this.dimmer).channels.remove(new Integer(1.access$000(this.this$1)));
                        1.access$100(this.this$1).firePatchChannelChanged(1.access$000(this.this$1));
                        1.access$100(this.this$1).firePatchDimmerChanged(this.dimmer);
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return this.add((Integer)x0);
            }

            static /* synthetic */ int access$000(1 x0) {
                return x0.channel;
            }

            static /* synthetic */ Patch access$100(1 x0) {
                return x0.Patch.this;
            }
        };
    }

    public Set<Integer> getChannelsForDimmer(final int dimmer) {
        final List<Integer> chan4dim = this.dimmers.get((int)dimmer).channels;
        return new AbstractSet<Integer>(){

            @Override
            public int size() {
                return chan4dim.size();
            }

            @Override
            public boolean add(Integer element) {
                if (chan4dim.contains(element)) {
                    return false;
                }
                int channel = element;
                Patch.this.channels.get((int)channel).dimmers.add(new Integer(dimmer));
                chan4dim.add(element);
                Patch.this.firePatchChannelChanged(channel);
                Patch.this.firePatchDimmerChanged(dimmer);
                return true;
            }

            @Override
            public Iterator<Integer> iterator() {
                Iterator it = chan4dim.iterator();
                return new Iterator<Integer>(){
                    int channel;
                    private final /* synthetic */ Iterator val$it;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$it = iterator;
                    }

                    public boolean hasNext() {
                        return this.val$it.hasNext();
                    }

                    public Integer next() {
                        Integer i = (Integer)this.val$it.next();
                        this.channel = i;
                        return i;
                    }

                    public void remove() {
                        this.val$it.remove();
                        3.access$300(this.this$1).channels.get((int)this.channel).dimmers.remove(new Integer(3.access$200(this.this$1)));
                        3.access$300(this.this$1).firePatchChannelChanged(this.channel);
                        3.access$300(this.this$1).firePatchDimmerChanged(3.access$200(this.this$1));
                    }

                    public /* synthetic */ Object next() {
                        return this.next();
                    }
                };
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return this.add((Integer)x0);
            }

            static /* synthetic */ int access$200(3 x0) {
                return x0.dimmer;
            }

            static /* synthetic */ Patch access$300(3 x0) {
                return x0.Patch.this;
            }
        };
    }

    public void addPatchListener(Listener l) {
        if (this.listenerList == null) {
            this.listenerList = new LinkedList();
        }
        this.listenerList.add(0, l);
    }

    public void removePatchListener(Listener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(l);
    }

    protected void firePatchAncestorChanged() {
        this.firePatchAncestorChanged(null);
    }

    protected void firePatchAncestorChanged(ChangeEvent e) {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = e;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).patchAncestorChanged(changeEvent);
        }
    }

    protected void firePatchNumDimmersChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).patchNumDimmersChanged(changeEvent);
        }
    }

    protected void firePatchNumChannelsChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).patchNumChannelsChanged(changeEvent);
        }
    }

    protected void firePatchChannelChanged(int which) {
        if (this.listenerList == null) {
            return;
        }
        ChannelChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChannelChangeEvent(this, which);
            }
            ((Listener)it.next()).patchChannelChanged(changeEvent);
        }
    }

    protected void firePatchDimmerChanged(int which) {
        if (this.listenerList == null) {
            return;
        }
        DimmerChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new DimmerChangeEvent(this, which);
            }
            ((Listener)it.next()).patchDimmerChanged(changeEvent);
        }
    }

    private void registerListeners() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$chirpcheap$jchirp$Model$Patch == null ? (class$com$chirpcheap$jchirp$Model$Patch = Patch.class$("com.chirpcheap.jchirp.Model.Patch")) : class$com$chirpcheap$jchirp$Model$Patch).desiredAssertionStatus();
    }

    public static class DimmerChangeEvent
    extends ChangeEvent {
        public final int dimmer;

        DimmerChangeEvent(Object source, int dimmer) {
            super(source);
            this.dimmer = dimmer;
        }
    }

    public static class ChannelChangeEvent
    extends ChangeEvent {
        public final int channel;

        ChannelChangeEvent(Object source, int channel) {
            super(source);
            this.channel = channel;
        }
    }

    public static abstract class Adapter
    implements Listener {
        public void patchAncestorChanged(ChangeEvent event) {
        }

        public void patchNumChannelsChanged(ChangeEvent event) {
        }

        public void patchNumDimmersChanged(ChangeEvent event) {
        }

        public void patchChannelChanged(ChannelChangeEvent event) {
        }

        public void patchDimmerChanged(DimmerChangeEvent event) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void patchAncestorChanged(ChangeEvent var1);

        public void patchNumChannelsChanged(ChangeEvent var1);

        public void patchNumDimmersChanged(ChangeEvent var1);

        public void patchChannelChanged(ChannelChangeEvent var1);

        public void patchDimmerChanged(DimmerChangeEvent var1);
    }

    static class DimmerAssignment
    implements Serializable {
        List<Integer> channels = new ArrayList<Integer>(2);

        DimmerAssignment() {
        }
    }

    static class ChannelAssignment
    implements Serializable {
        String channelName = null;
        List<Integer> dimmers = new ArrayList<Integer>(2);

        ChannelAssignment() {
        }
    }
}

