/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.Model;

import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.Patch;
import com.chirpcheap.jchirp.Model.Show;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class Cue
implements Serializable {
    private String notes;
    private CueNumber cueNumber;
    private CueTime upTime;
    private CueTime downTime;
    private CueTime delayTime;
    private CueNumber linkNumber;
    private CueTime linkTime;
    private short[] levels;
    public final Patch patch;
    transient LinkedList<Listener> listenerList;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cue(CueNumber cueNumber, Show show) {
        this(cueNumber, show.getDefaultTime(), show.getDefaultTime(), new CueTime(0), null, new CueTime(0), new short[show.patch.getNumChannels()], null, show.patch);
    }

    Cue(CueNumber cueNumber, CueTime upTime, CueTime downTime, CueTime delayTime, CueNumber linkNumber, CueTime linkTime, short[] levels, String notes, Patch patch) {
        this.cueNumber = cueNumber;
        this.upTime = upTime;
        this.downTime = downTime;
        this.delayTime = delayTime;
        this.linkNumber = linkNumber;
        this.linkTime = linkTime;
        this.levels = (short[])levels.clone();
        this.notes = notes;
        this.patch = patch;
        this.registerListeners();
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.registerListeners();
    }

    private boolean isValid() {
        if (!($assertionsDisabled || this.cueNumber != null && this.cueNumber.isValid())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.upTime != null && this.upTime.isValid())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.downTime != null && this.downTime.isValid())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.delayTime != null && this.delayTime.isValid())) {
            throw new AssertionError();
        }
        if (this.linkNumber != null) {
            if (!$assertionsDisabled && !this.linkNumber.isValid()) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || this.linkTime != null && this.linkTime.isValid())) {
                throw new AssertionError();
            }
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (!($assertionsDisabled || this.levels[i] >= 0 && this.levels[i] <= 100)) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.patch == null) {
            throw new AssertionError();
        }
        return true;
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public CueNumber getCueNumber() {
        return this.cueNumber;
    }

    public CueTime getUpTime() {
        return this.upTime;
    }

    public CueTime getDownTime() {
        return this.downTime;
    }

    public CueTime getDelayTime() {
        return this.delayTime;
    }

    public String getCueTimeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.upTime.toString());
        if (!this.upTime.equals(this.downTime)) {
            sb.append('u');
            sb.append('/');
            sb.append(this.downTime.toString());
            sb.append('d');
        }
        if (this.delayTime.tenths > 0) {
            sb.append('w');
            sb.append(this.delayTime.toString());
        }
        return sb.toString();
    }

    public CueNumber getLinkNumber() {
        return this.linkNumber;
    }

    public CueTime getLinkTime() {
        if (this.linkNumber == null) {
            return new CueTime(0);
        }
        if (!($assertionsDisabled || this.linkNumber != null && this.linkTime != null)) {
            throw new AssertionError();
        }
        return this.linkTime;
    }

    public short getLevel(int chan) {
        if (chan < this.levels.length) {
            return this.levels[chan];
        }
        return 0;
    }

    public void setNotes(String notes) {
        if (notes != null && notes.length() == 0) {
            notes = null;
        }
        if (notes == null ? this.notes == null : notes.equals(this.notes)) {
            return;
        }
        this.notes = notes;
        this.fireCueInfoChanged(0);
    }

    void setCueNumber(CueNumber cueNumber) {
        if (!$assertionsDisabled && cueNumber == null) {
            throw new AssertionError();
        }
        if (this.cueNumber.equals(cueNumber)) {
            return;
        }
        this.cueNumber = cueNumber;
        this.fireCueInfoChanged(1);
    }

    public void setUpTime(CueTime upTime) {
        if (!$assertionsDisabled && upTime == null) {
            throw new AssertionError();
        }
        if (this.upTime.equals(upTime)) {
            return;
        }
        this.upTime = upTime;
        this.fireCueInfoChanged(2);
    }

    public void setDownTime(CueTime downTime) {
        if (!$assertionsDisabled && downTime == null) {
            throw new AssertionError();
        }
        if (this.downTime.equals(downTime)) {
            return;
        }
        this.downTime = downTime;
        this.fireCueInfoChanged(2);
    }

    public void setDelayTime(CueTime delayTime) {
        if (!$assertionsDisabled && delayTime == null) {
            throw new AssertionError();
        }
        if (this.delayTime.equals(delayTime)) {
            return;
        }
        this.delayTime = delayTime;
        this.fireCueInfoChanged(2);
    }

    public void setLinkNumber(CueNumber linkNumber) {
        if (this.linkNumber == null ? linkNumber == null : this.linkNumber.equals(linkNumber)) {
            return;
        }
        this.linkNumber = linkNumber;
        this.fireCueInfoChanged(3);
    }

    public void setLinkTime(CueTime linkTime) {
        if (!$assertionsDisabled && linkTime == null) {
            throw new AssertionError();
        }
        if (this.linkTime.equals(linkTime)) {
            return;
        }
        this.linkTime = linkTime;
        this.fireCueInfoChanged(3);
    }

    public void setLevel(int chan, short newLevel) {
        if (!($assertionsDisabled || newLevel >= 0 && newLevel <= 100)) {
            throw new AssertionError();
        }
        if (this.levels[chan] == newLevel) {
            return;
        }
        this.levels[chan] = newLevel;
        this.fireCueLevelsChangedOne(chan);
    }

    public void setLevels(int startChan, short[] newLevels) {
        boolean changed = false;
        for (int i = 0; i < newLevels.length; ++i) {
            if (!($assertionsDisabled || newLevels[i] >= 0 && newLevels[i] <= 100)) {
                throw new AssertionError();
            }
            if (this.levels[startChan + i] != newLevels[i]) {
                changed = true;
            }
            this.levels[startChan + i] = newLevels[i];
        }
        if (!changed) {
            return;
        }
        this.fireCueLevelsChanged(startChan, startChan + newLevels.length - 1);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cue)) {
            return false;
        }
        return this.cueNumber.equals(((Cue)o).cueNumber);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cue#");
        sb.append(this.cueNumber);
        sb.append("[up=");
        sb.append(this.upTime);
        sb.append(",down=");
        sb.append(this.downTime);
        sb.append(",delay=");
        sb.append(this.delayTime);
        if (this.linkNumber == null) {
            sb.append(",no link");
        } else {
            sb.append(",link=");
            sb.append(this.linkNumber);
            sb.append(",link time=");
            sb.append(this.linkTime);
        }
        sb.append(",levels=");
        sb.append(new AbstractList<Short>(){

            @Override
            public int size() {
                return Cue.this.levels.length;
            }

            @Override
            public Short get(int i) {
                return new Short(Cue.this.levels[i]);
            }

            @Override
            public /* synthetic */ Object remove(int x0) {
                return super.remove(x0);
            }

            @Override
            public /* synthetic */ void add(int x0, Object x1) {
                super.add(x0, (Short)x1);
            }

            @Override
            public /* synthetic */ Object set(int x0, Object x1) {
                return super.set(x0, (Short)x1);
            }

            @Override
            public /* synthetic */ Object get(int x0) {
                return this.get(x0);
            }

            @Override
            public /* synthetic */ boolean add(Object x0) {
                return super.add((Short)x0);
            }
        });
        sb.append(",notes=\"");
        sb.append(this.escape(this.notes));
        sb.append("\"");
        sb.append(",patch=");
        sb.append(this.patch);
        sb.append("]");
        return sb.toString();
    }

    private String escape(String str) {
        return Pattern.compile("[^ \\p{Print}]").matcher(str).replaceAll("?");
    }

    public void addCueListener(Listener l) {
        if (this.listenerList == null) {
            this.listenerList = new LinkedList();
        }
        this.listenerList.add(0, l);
    }

    public void removeCueListener(Listener l) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(l);
    }

    protected void fireCueLevelsChangedAll() {
        this.fireCueLevelsChanged(0, this.patch.getNumChannels() - 1);
    }

    protected void fireCueLevelsChangedOne(int channel) {
        this.fireCueLevelsChanged(channel, channel);
    }

    protected void fireCueLevelsChanged(int startChannel, int endChannel) {
        if (!($assertionsDisabled || 0 <= startChannel && startChannel < this.patch.getNumChannels())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= endChannel && endChannel < this.patch.getNumChannels())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && startChannel > endChannel) {
            throw new AssertionError();
        }
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this, 4, startChannel, endChannel);
            }
            ((Listener)it.next()).cueLevelsChanged(changeEvent);
        }
    }

    protected void fireCueInfoChanged(int type) {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this, type);
            }
            ((Listener)it.next()).cueInfoChanged(changeEvent);
        }
    }

    private void registerListeners() {
    }

    static {
        $assertionsDisabled = !Cue.class.desiredAssertionStatus();
    }

    public static class ChangeEvent
    extends javax.swing.event.ChangeEvent {
        public static final int NOTES = 0;
        public static final int NUMBER = 1;
        public static final int TIMES = 2;
        public static final int LINK = 3;
        public static final int LEVELS = 4;
        int type;
        int startChannel;
        int endChannel;
        static final /* synthetic */ boolean $assertionsDisabled;

        ChangeEvent(Cue source, int type) {
            this(source, type, 0, 0);
            if (!$assertionsDisabled && type == 4) {
                throw new AssertionError();
            }
        }

        ChangeEvent(Cue source, int type, int startChannel, int endChannel) {
            super(source);
            this.type = type;
            this.startChannel = startChannel;
            this.endChannel = endChannel;
        }

        public Cue getSource() {
            return (Cue)super.getSource();
        }

        public int getType() {
            return this.type;
        }

        public int getStartChannel() {
            return this.startChannel;
        }

        public int getEndChannel() {
            return this.endChannel;
        }

        public /* synthetic */ Object getSource() {
            return this.getSource();
        }

        static {
            $assertionsDisabled = !(class$com$chirpcheap$jchirp$Model$Cue == null ? (class$com$chirpcheap$jchirp$Model$Cue = Cue.class$("com.chirpcheap.jchirp.Model.Cue")) : class$com$chirpcheap$jchirp$Model$Cue).desiredAssertionStatus();
        }
    }

    public static abstract class Adapter
    implements Listener {
        public void cueLevelsChanged(ChangeEvent event) {
        }

        public void cueInfoChanged(ChangeEvent event) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void cueLevelsChanged(ChangeEvent var1);

        public void cueInfoChanged(ChangeEvent var1);
    }
}

