/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.Model;

import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.RunState;
import com.chirpcheap.jchirp.Model.Show;
import java.io.File;
import java.text.ParseException;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;

public class Application {
    RunState runState;
    private static final Preferences prefs = Preferences.userNodeForPackage(Application.class);
    final LinkedList<Listener> listenerList;

    public Application() {
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                Application.this.fireApplicationPrefsChanged();
            }
        });
        this.listenerList = new LinkedList();
        this.addApplicationListener(new Adapter(){
            RunState oldRunState;
            {
                this.oldRunState = Application.this.runState;
            }

            public void applicationRunStateChanged(ChangeEvent e) {
                if (this.oldRunState != null) {
                    this.oldRunState.fireRunStateAncestorChanged(e);
                }
                this.oldRunState = Application.this.runState;
            }
        });
        this.runState = new RunState(this);
        this.fireApplicationRunStateChanged();
        this.fireApplicationPrefsChanged();
    }

    public RunState getRunState() {
        return this.runState;
    }

    public int getDefaultNumDimmers() {
        return prefs.getInt("NUM_DIMMERS", 120);
    }

    public int getDefaultNumChannels() {
        return prefs.getInt("NUM_CHANNELS", 120);
    }

    public CueTime getDefaultTime() {
        String DEFAULT = "3";
        String[] options = new String[]{prefs.get("DEFAULT_TIME", DEFAULT), DEFAULT};
        for (int i = 0; i < options.length; ++i) {
            try {
                return CueTime.valueOf(options[i]);
            }
            catch (ParseException e) {
                continue;
            }
        }
        throw new RuntimeException("Bad default for default cue time");
    }

    public File getDefaultShowDirectory() {
        String path = prefs.get("SHOW_DIR", null);
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (!f.isDirectory()) {
            return null;
        }
        return f;
    }

    public boolean isSilent() {
        return prefs.getBoolean("SILENT_MODE", false);
    }

    public void setDefaultNumDimmers(int defaultNumDimmers) {
        if (this.getDefaultNumDimmers() == defaultNumDimmers) {
            return;
        }
        prefs.putInt("NUM_DIMMERS", defaultNumDimmers);
        this.flush();
    }

    public void setDefaultNumChannels(int defaultNumChannels) {
        if (this.getDefaultNumChannels() == defaultNumChannels) {
            return;
        }
        prefs.putInt("NUM_CHANNELS", defaultNumChannels);
        this.flush();
    }

    public void setDefaultTime(CueTime defaultTime) {
        if (this.getDefaultTime().equals(defaultTime)) {
            return;
        }
        prefs.put("DEFAULT_TIME", defaultTime.toString());
        this.flush();
    }

    public void setDefaultShowDirectory(File showDir) {
        if (showDir == null ? this.getDefaultShowDirectory() == null : showDir.equals(this.getDefaultShowDirectory())) {
            return;
        }
        prefs.put("SHOW_DIR", showDir.toString());
        this.flush();
    }

    public void setSilent(boolean isSilent) {
        if (this.isSilent() == isSilent) {
            return;
        }
        prefs.putBoolean("SILENT_MODE", isSilent);
        this.flush();
    }

    public void newShow() {
        this.runState = new RunState(new Show(this), this.runState);
        this.fireApplicationRunStateChanged();
    }

    public boolean openShow(File file) {
        Show show = Show.load(file);
        if (show == null) {
            return false;
        }
        this.runState = new RunState(show, this.runState);
        this.fireApplicationRunStateChanged();
        return true;
    }

    public boolean saveShow(File file) {
        return this.runState.show.save(file);
    }

    private void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void addApplicationListener(Listener l) {
        this.listenerList.add(0, l);
    }

    public void removeApplicationListener(Listener l) {
        this.listenerList.remove(l);
    }

    protected void fireApplicationPrefsChanged() {
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).applicationPrefsChanged(changeEvent);
        }
    }

    protected void fireApplicationRunStateChanged() {
        ChangeEvent changeEvent = null;
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((Listener)it.next()).applicationRunStateChanged(changeEvent);
        }
    }

    public static abstract class Adapter
    implements Listener {
        public void applicationPrefsChanged(ChangeEvent e) {
        }

        public void applicationRunStateChanged(ChangeEvent e) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void applicationPrefsChanged(ChangeEvent var1);

        public void applicationRunStateChanged(ChangeEvent var1);
    }
}

