/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.OKDialog;
import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.Patch;
import com.chirpcheap.jchirp.Model.Show;
import com.chirpcheap.jchirp.swing.CCFormattedTextField;
import com.chirpcheap.jchirp.swing.CommitListener;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;

public class PropertiesDialog
extends OKDialog {
    final Application application;
    final JCheckBox editButton;
    final CCFormattedTextField fadeField;
    final JSpinner chanSpin;
    final JSpinner dimSpin;
    final JCheckBox patchButton;
    final JLabel editLabel;
    final JLabel fadeLabel;
    final JLabel chanLabel;
    final JLabel dimLabel;
    final JLabel patchLabel;

    public PropertiesDialog(Frame parent, Application application) {
        super(parent, "Show Properties", false, true);
        this.application = application;
        JPanel contentPane = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        this.editLabel = new JLabel("Changes to Show are: ");
        this.fadeLabel = new JLabel("Default Fade Time: ");
        this.chanLabel = new JLabel("Number of Channels: ");
        this.dimLabel = new JLabel("Number of Dimmers: ");
        this.patchLabel = new JLabel("Patch is: ");
        this.editButton = new JCheckBox("Allowed");
        this.fadeField = new CCFormattedTextField(new CueTime.Format(false));
        this.chanSpin = new JSpinner(new SpinnerNumberModel(120, 1, 120, 1));
        this.dimSpin = new JSpinner(new SpinnerNumberModel(120, 1, 120, 1));
        this.patchButton = new JCheckBox("One to One");
        this.editButton.setMnemonic(65);
        this.fadeLabel.setDisplayedMnemonic(70);
        this.fadeLabel.setDisplayedMnemonicIndex(8);
        this.chanLabel.setDisplayedMnemonic(67);
        this.dimLabel.setDisplayedMnemonic(68);
        this.patchButton.setMnemonic(79);
        this.fadeField.setDragEnabled(true);
        this.addLabelTextRows(new JLabel[]{this.fadeLabel}, new JComponent[]{this.fadeField}, null, gridbag, contentPane);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(3, 0, 3, 0);
        contentPane.add((Component)new JSeparator(), c);
        this.addLabelTextRows(new JLabel[]{this.chanLabel, this.dimLabel}, new JComponent[]{this.chanSpin, this.dimSpin}, null, gridbag, contentPane);
        contentPane.add((Component)new JSeparator(), c);
        this.addLabelTextRows(new JLabel[]{this.patchLabel, this.editLabel}, new JComponent[]{this.patchButton, this.editButton}, null, gridbag, contentPane);
        c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weighty = 1.0;
        contentPane.add((Component)new JPanel(), c);
        this.editButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesDialog.this.updateEnable();
            }
        });
        this.updateEnable();
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesDialog.this.updateReset();
            }
        };
        CommitListener col = new CommitListener(){

            public void valueCommitted(ChangeEvent e) {
                PropertiesDialog.this.updateReset();
            }
        };
        ChangeListener chl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PropertiesDialog.this.updateReset();
            }
        };
        this.editButton.addItemListener(il);
        this.fadeField.addCommitListener(col);
        this.chanSpin.addChangeListener(chl);
        this.dimSpin.addChangeListener(chl);
        this.patchButton.addItemListener(il);
        new Show.Adapter(){

            public void showAncestorChanged(ChangeEvent e) {
                PropertiesDialog.this.application.getRunState().show.addShowListener(this);
                this.showEditableChanged(e);
                this.showDefaultTimeChanged(e);
            }

            public void showEditableChanged(ChangeEvent e) {
                PropertiesDialog.this.resetEdit();
            }

            public void showDefaultTimeChanged(ChangeEvent e) {
                PropertiesDialog.this.resetFade();
            }
        }.showAncestorChanged(null);
        new Patch.Adapter(){

            public void patchAncestorChanged(ChangeEvent e) {
                PropertiesDialog.this.application.getRunState().show.patch.addPatchListener(this);
                this.patchNumChannelsChanged(e);
                this.patchNumDimmersChanged(e);
                this.patchChannelChanged(null);
            }

            public void patchNumChannelsChanged(ChangeEvent e) {
                PropertiesDialog.this.resetChan();
            }

            public void patchNumDimmersChanged(ChangeEvent e) {
                PropertiesDialog.this.resetDim();
            }

            public void patchChannelChanged(Patch.ChannelChangeEvent e) {
                PropertiesDialog.this.resetPatch();
            }
        }.patchAncestorChanged(null);
        this.resetAction.setEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                PropertiesDialog.this.resetAction.actionPerformed(null);
            }
        });
        this.pack();
    }

    protected ActionListener cancelListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesDialog.this.setVisible(false);
            }
        };
    }

    protected ActionListener okListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PropertiesDialog.this.checkEdit()) {
                    PropertiesDialog.this.resetEdit();
                } else if (!PropertiesDialog.this.checkFade()) {
                    PropertiesDialog.this.resetFade();
                } else if (!PropertiesDialog.this.checkChan()) {
                    PropertiesDialog.this.resetChan();
                } else if (!PropertiesDialog.this.checkDim()) {
                    PropertiesDialog.this.resetDim();
                } else if (!PropertiesDialog.this.checkPatch()) {
                    PropertiesDialog.this.resetPatch();
                } else {
                    PropertiesDialog.this.setEdit();
                    PropertiesDialog.this.setFade();
                    PropertiesDialog.this.setChan();
                    PropertiesDialog.this.setDim();
                    PropertiesDialog.this.setPatch();
                    PropertiesDialog.this.setVisible(false);
                }
            }
        };
    }

    protected ActionListener resetListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesDialog.this.resetEdit();
                PropertiesDialog.this.resetFade();
                PropertiesDialog.this.resetChan();
                PropertiesDialog.this.resetDim();
                PropertiesDialog.this.resetPatch();
                PropertiesDialog.this.resetAction.setEnabled(false);
            }
        };
    }

    private void updateEnable() {
        boolean isEnabled = this.editButton.isSelected();
        this.fadeField.setEnabled(isEnabled);
        this.fadeLabel.setEnabled(isEnabled);
        this.chanSpin.setEnabled(isEnabled);
        this.chanLabel.setEnabled(isEnabled);
        this.dimSpin.setEnabled(isEnabled);
        this.dimLabel.setEnabled(isEnabled);
        isEnabled = isEnabled && !this.getPatch();
        this.patchButton.setEnabled(isEnabled);
        this.patchLabel.setEnabled(isEnabled);
    }

    private void updateReset() {
        this.resetAction.setEnabled(true);
    }

    private boolean checkEdit() {
        return true;
    }

    private boolean checkFade() {
        return true;
    }

    private boolean checkChan() {
        int newnum = ((Number)this.chanSpin.getValue()).intValue();
        if (newnum >= this.getChan()) {
            return true;
        }
        int returnValue = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove channels " + (newnum + 1) + " through " + this.getChan() + " from the patch and all cues?", "Confirm Channel Removal", 2);
        return returnValue == 0;
    }

    private boolean checkDim() {
        int newnum = ((Number)this.dimSpin.getValue()).intValue();
        if (newnum >= this.getDim()) {
            return true;
        }
        int returnValue = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the patch for dimmers " + (newnum + 1) + " through " + this.getDim() + "?", "Confirm Dimmer Removal", 2);
        return returnValue == 0;
    }

    private boolean checkPatch() {
        if (!this.patchButton.isSelected()) {
            return true;
        }
        if (this.getPatch()) {
            return true;
        }
        int returnValue = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset the patch?", "Confirm Patch Reset", 2);
        return returnValue == 0;
    }

    private boolean getEdit() {
        return this.application.getRunState().show.isEditable();
    }

    private CueTime getFade() {
        return this.application.getRunState().show.getDefaultTime();
    }

    private int getChan() {
        Patch patch = this.application.getRunState().show.patch;
        return patch.getNumChannels();
    }

    private int getDim() {
        Patch patch = this.application.getRunState().show.patch;
        return patch.getNumDimmers();
    }

    private boolean getPatch() {
        Patch patch = this.application.getRunState().show.patch;
        int limit = Math.min(patch.getNumChannels(), patch.getNumDimmers());
        for (int i = 0; i < limit; ++i) {
            Set<Integer> dims = patch.getDimmersForChannel(i);
            Set<Integer> chans = patch.getChannelsForDimmer(i);
            if (dims.size() != 1) {
                return false;
            }
            if (((Object)dims).equals(chans)) continue;
            return false;
        }
        return true;
    }

    private boolean sameEdit() {
        return this.getEdit() == this.editButton.isSelected();
    }

    private boolean sameFade() {
        return this.getFade().equals(this.fadeField.getValue());
    }

    private boolean sameChan() {
        return this.chanSpin.getValue() != null && this.getChan() == ((Number)this.chanSpin.getValue()).intValue();
    }

    private boolean sameDim() {
        return this.dimSpin.getValue() != null && this.getDim() == ((Number)this.dimSpin.getValue()).intValue();
    }

    private boolean samePatch() {
        return this.getPatch() == this.patchButton.isSelected();
    }

    private void resetEdit() {
        if (this.sameEdit()) {
            return;
        }
        this.editButton.setSelected(this.getEdit());
    }

    private void resetFade() {
        if (this.sameFade()) {
            return;
        }
        this.fadeField.setValue(this.getFade());
    }

    private void resetChan() {
        if (this.sameChan()) {
            return;
        }
        this.chanSpin.setValue(new Integer(this.getChan()));
    }

    private void resetDim() {
        if (this.sameDim()) {
            return;
        }
        this.dimSpin.setValue(new Integer(this.getDim()));
    }

    private void resetPatch() {
        if (this.samePatch()) {
            return;
        }
        this.patchButton.setSelected(this.getPatch());
        this.updateEnable();
    }

    private void setEdit() {
        if (this.sameEdit()) {
            return;
        }
        this.application.getRunState().show.setEditable(this.editButton.isSelected());
    }

    private void setFade() {
        if (this.sameFade()) {
            return;
        }
        CueTime ct = (CueTime)this.fadeField.getValue();
        this.application.getRunState().show.setDefaultTime(ct);
        this.application.setDefaultTime(ct);
    }

    private void setChan() {
        if (this.sameChan()) {
            return;
        }
        int numChan = ((Number)this.chanSpin.getValue()).intValue();
        this.application.getRunState().show.patch.setNumChannels(numChan);
        this.application.setDefaultNumChannels(numChan);
    }

    private void setDim() {
        if (this.sameDim()) {
            return;
        }
        int numDim = ((Number)this.dimSpin.getValue()).intValue();
        this.application.getRunState().show.patch.setNumDimmers(numDim);
        this.application.setDefaultNumDimmers(numDim);
    }

    private void setPatch() {
        if (this.samePatch()) {
            return;
        }
        if (this.patchButton.isSelected()) {
            this.application.getRunState().show.patch.makeOneToOne();
        }
    }

    private void tweak(JFormattedTextField tf) {
        ((DefaultFormatter)tf.getFormatter()).setAllowsInvalid(false);
    }
}

