/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.Icons;
import com.chirpcheap.jchirp.swing.EqualHeightLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public abstract class OKDialog
extends JDialog {
    final JPanel contentPane = new JPanel();
    protected final Action okAction = OKDialog.makeAction("OK", Icons.OK, -1, this.okListener());
    protected final Action cancelAction = OKDialog.makeAction("Cancel", Icons.CANCEL, -1, this.cancelListener());
    protected final Action resetAction = OKDialog.makeAction("Reset", Icons.RESET, 82, this.resetListener());

    public OKDialog(Frame parent, String title, boolean isModal, boolean useDefaultButton) {
        super(parent, "JChirp: " + title, isModal);
        JPanel superContent = new JPanel(new BorderLayout());
        super.getContentPane().add(superContent);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel commandButtonPanel = new JPanel(new EqualHeightLayout(5));
        superContent.add((Component)bottomPanel, "South");
        superContent.add((Component)this.getContentPane(), "Center");
        JSeparator sep = new JSeparator();
        JPanel sepPanel = new JPanel(new BorderLayout());
        sepPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        sepPanel.add(sep);
        bottomPanel.add((Component)sepPanel, "North");
        bottomPanel.add((Component)commandButtonPanel, "East");
        superContent.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        if (this.okAction != null) {
            JButton okButton = new JButton(this.okAction);
            commandButtonPanel.add(okButton);
            if (useDefaultButton) {
                this.getRootPane().setDefaultButton(okButton);
            }
        }
        if (this.resetAction != null) {
            JButton resetButton = new JButton(this.resetAction);
            commandButtonPanel.add(resetButton);
        }
        if (this.cancelAction != null) {
            JButton cancelButton = new JButton(this.cancelAction);
            commandButtonPanel.add(cancelButton);
            superContent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            superContent.getActionMap().put("cancel", this.cancelAction);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                OKDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.setDefaultCloseOperation(0);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    protected abstract ActionListener okListener();

    protected abstract ActionListener cancelListener();

    protected ActionListener resetListener() {
        return null;
    }

    private static Action makeAction(String name, Icon icon, final int key, final ActionListener listener) {
        if (listener == null) {
            return null;
        }
        return new AbstractAction(name, icon){
            {
                super(x0, x1);
                if (key > 0) {
                    this.putValue("MnemonicKey", new Integer(key));
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        };
    }

    protected void addLabelTextRows(JLabel[] labels, JComponent[] textFields, Insets[] insets, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            if (insets != null) {
                c.insets = insets[i];
            }
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(textFields[i], c);
            container.add(textFields[i]);
            labels[i].setLabelFor(textFields[i]);
        }
    }

    public /* synthetic */ Container getContentPane() {
        return this.getContentPane();
    }
}

