/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.Icons;
import com.chirpcheap.jchirp.GUI.JCueTable;
import com.chirpcheap.jchirp.GUI.JPatchTable;
import com.chirpcheap.jchirp.GUI.JStageComponent;
import com.chirpcheap.jchirp.GUI.JStatusBar;
import com.chirpcheap.jchirp.GUI.JumpDialog;
import com.chirpcheap.jchirp.GUI.LAFDialog;
import com.chirpcheap.jchirp.GUI.PropertiesDialog;
import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.RunState;
import com.chirpcheap.jchirp.Model.Show;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class MainWindow
extends JFrame
implements LAFDialog.Unpackable {
    final Application application;
    final JFileChooser fileChooser;
    static final String SHOW_EXT = ".shw";
    final JStageComponent stageComponent;
    final JCueTable cueTable;
    final JPatchTable patchTable;
    final JStatusBar statusBar;
    final Action aboutAction = new AboutAction();
    final Action copyAction = new CopyAction();
    final Action cutAction = new CutAction();
    final Action deleteAction = new DeleteAction();
    final Action exitAction = new ExitAction();
    final Action newAction = new NewAction();
    public final Action openAction = new OpenAction();
    final Action pageSetupAction = new PageSetupAction();
    final Action pasteAction = new PasteAction();
    final Action preferencesAction = new PreferencesAction();
    final Action printAction = new PrintAction();
    final Action propertiesAction = new PropertiesAction();
    PropertiesDialog propertiesDialog = null;
    final Action redoAction = new RedoAction();
    final Action revertAction = new RevertAction();
    final Action saveAction = new SaveAction();
    final Action saveAsAction = new SaveAsAction();
    final Action undoAction = new UndoAction();
    final Action cueGoAction = new CueGoAction();
    final Action cueHaltAction = new CueHaltAction();
    final Action cueBackAction = new CueBackAction();
    final Action cueSkipToAction = new CueSkipToAction();
    JumpDialog jumpDialog = null;
    final Action rowDeleteAction = new RowDeleteAction();
    final Action rowInsertAfterAction = new RowInsertAfterAction();
    final Action rowInsertBeforeAction = new RowInsertBeforeAction();
    final Action themeAction = new ThemeAction();
    LAFDialog themeDialog = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MainWindow(Application application) {
        this.application = application;
        this.fileChooser = new JFileChooser(application.getDefaultShowDirectory());
        this.fileChooser.setDragEnabled(true);
        this.fileChooser.addChoosableFileFilter(new ShowFilter());
        this.fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.application.setDefaultShowDirectory(MainWindow.this.fileChooser.getCurrentDirectory());
            }
        });
        this.setIconImage(Icons.MAIN_WINDOW.getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.exitAction.actionPerformed(null);
            }
        });
        Container contentPane = this.getContentPane();
        JPanel interiorPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)interiorPanel, "Center");
        this.statusBar = new JStatusBar(application);
        contentPane.add((Component)this.statusBar, "South");
        final JTabbedPane tabbedPane = new JTabbedPane();
        interiorPanel.add((Component)tabbedPane, "Center");
        tabbedPane.setBorder(new SoftBevelBorder(1));
        this.stageComponent = new JStageComponent();
        tabbedPane.addTab("Stage", null, this.stageComponent, "Show the current levels up on stage");
        this.cueTable = new JCueTable(this, application);
        JScrollPane cuePane = new JScrollPane(this.cueTable);
        tabbedPane.addTab("Cues", null, cuePane, "Edit cues without affecting stage levels");
        this.patchTable = new JPatchTable(application);
        JScrollPane patchPane = new JScrollPane(this.patchTable);
        tabbedPane.addTab("Patch", null, patchPane, "Edit the channel-to-dimmer patch for the show");
        JToolBar toolBar = new JToolBar();
        interiorPanel.add((Component)toolBar, "North");
        toolBar.add(this.iconButton(this.newAction));
        toolBar.add(this.iconButton(this.openAction));
        toolBar.add(this.iconButton(this.saveAction));
        toolBar.add(this.iconButton(this.printAction));
        toolBar.addSeparator();
        toolBar.add(this.iconButton(this.cutAction));
        toolBar.add(this.iconButton(this.copyAction));
        toolBar.add(this.iconButton(this.pasteAction));
        toolBar.add(this.iconButton(this.deleteAction));
        toolBar.addSeparator();
        toolBar.add(this.iconButton(this.rowInsertAfterAction));
        toolBar.add(this.iconButton(this.rowDeleteAction));
        toolBar.addSeparator();
        toolBar.add(this.iconButton(this.cueBackAction));
        toolBar.add(this.iconButton(this.cueHaltAction));
        toolBar.add(this.iconButton(this.cueGoAction));
        toolBar.add(this.iconButton(this.cueSkipToAction));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Show");
        menu.setMnemonic(83);
        menu.getAccessibleContext().setAccessibleDescription("Create, load, save, or print a show");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem(this.newAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.openAction);
        menuItem.setActionCommand("");
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.saveAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.saveAsAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.revertAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(this.pageSetupAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.printAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(this.exitAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menu.getAccessibleContext().setAccessibleDescription("Cut, copy, and paste levels in cues or edit show properties");
        menuBar.add(menu);
        menuItem = new JMenuItem(this.undoAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.redoAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(this.cutAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.copyAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.pasteAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menuItem = new JMenuItem(this.deleteAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(this.propertiesAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        menu.getAccessibleContext().setAccessibleDescription("Select show, blind, or patch page");
        menuBar.add(menu);
        ActionListener switchView = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Integer.parseInt(e.getActionCommand());
                if (index != tabbedPane.getSelectedIndex()) {
                    tabbedPane.setSelectedIndex(index);
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        final JRadioButtonMenuItem[] rbMenuItem = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem("Stage"), new JRadioButtonMenuItem("Cues"), new JRadioButtonMenuItem("Patch"), new JRadioButtonMenuItem("Setup")};
        int[] mnemonic = new int[]{83, 67, 80, 84};
        String[] desc = new String[]{"Show the current levels up on stage", "Edit cues without affecting stage levels", "Edit the channel-to-dimmer patch for the show", "Setup the number of dimmers, etc."};
        for (int i = 0; i < 3; ++i) {
            rbMenuItem[i].setMnemonic(mnemonic[i]);
            rbMenuItem[i].getAccessibleContext().setAccessibleDescription(desc[i]);
            rbMenuItem[i].setActionCommand(Integer.toString(i));
            rbMenuItem[i].addActionListener(switchView);
            group.add(rbMenuItem[i]);
            menu.add(rbMenuItem[i]);
        }
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                rbMenuItem[tabbedPane.getSelectedIndex()].setSelected(true);
                MainWindow.this.updateView(tabbedPane.getSelectedIndex());
            }
        };
        cl.stateChanged(null);
        tabbedPane.addChangeListener(cl);
        menu.addSeparator();
        menuItem = new JMenuItem(this.themeAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu.getAccessibleContext().setAccessibleDescription("Get help using the program");
        menuBar.add(menu);
        menuItem = new JMenuItem(this.aboutAction);
        menuItem.addMouseListener(this.statusBar.mouseListener);
        menu.add(menuItem);
        new Show.Adapter(){

            public void showAncestorChanged(ChangeEvent event) {
                MainWindow.this.application.getRunState().show.addShowListener(this);
                this.showDirtyChanged(event);
                this.showFilenameChanged(event);
            }

            public void showDirtyChanged(ChangeEvent event) {
                MainWindow.this.saveAction.setEnabled(MainWindow.this.application.getRunState().show.isDirty());
            }

            public void showFilenameChanged(ChangeEvent event) {
                StringBuffer sb = new StringBuffer("JChirp");
                sb.append(':');
                sb.append(' ');
                File showfile = MainWindow.this.application.getRunState().show.getFilename();
                if (showfile == null) {
                    sb.append("(untitled)");
                } else {
                    sb.append(showfile.getName());
                }
                MainWindow.this.setTitle(sb.toString());
            }
        }.showAncestorChanged(null);
        new Show.Adapter(){

            public void showAncestorChanged(ChangeEvent event) {
                MainWindow.this.application.getRunState().show.addShowListener(this);
                this.updateRevert();
            }

            public void showDirtyChanged(ChangeEvent event) {
                this.updateRevert();
            }

            public void showFilenameChanged(ChangeEvent event) {
                this.updateRevert();
            }

            void updateRevert() {
                Show show = MainWindow.this.application.getRunState().show;
                MainWindow.this.revertAction.setEnabled(show.isDirty() && show.getFilename() != null);
            }
        }.showAncestorChanged(null);
        new RunState.Listener(){

            public void runStateAncestorChanged(ChangeEvent event) {
                MainWindow.this.application.getRunState().addRunStateListener(this);
                this.runStateFaderChanged(event);
                this.runStateCueProgress(event);
            }

            public void runStateFaderChanged(ChangeEvent event) {
                RunState rs = MainWindow.this.application.getRunState();
                MainWindow.this.cueGoAction.setEnabled(rs.getNextCue() != null);
                MainWindow.this.cueBackAction.setEnabled(rs.getCurrentCue() != null);
                this.runStateCueProgress(event);
            }

            public void runStateCueProgress(ChangeEvent event) {
                RunState rs = MainWindow.this.application.getRunState();
                MainWindow.this.cueHaltAction.setEnabled(rs.getCurrentCue() != null && rs.getProgress() < 1.0f);
            }
        }.runStateAncestorChanged(null);
    }

    void updateView(int which) {
        boolean isStage = which == 0;
        boolean isCues = which == 1;
        boolean isPatch = which == 2;
        this.rowDeleteAction.setEnabled(isCues);
        this.rowInsertAfterAction.setEnabled(isCues);
        this.rowInsertBeforeAction.setEnabled(isCues);
    }

    private JButton iconButton(Action action) {
        JButton button = new JButton(action);
        if (button.getIcon() != null) {
            button.setText("");
            button.setMnemonic(0);
        }
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.addMouseListener(this.statusBar.mouseListener);
        return button;
    }

    private void initPropertiesDialog() {
        if (!$assertionsDisabled && this.propertiesDialog != null) {
            throw new AssertionError();
        }
        this.propertiesDialog = new PropertiesDialog((Frame)this, this.application);
        this.propertiesDialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                MainWindow.this.propertiesAction.setEnabled(true);
            }

            public void componentShown(ComponentEvent e) {
                MainWindow.this.propertiesAction.setEnabled(false);
            }
        });
    }

    boolean saveQuestion() {
        if (!this.application.getRunState().show.isDirty()) {
            return true;
        }
        File file = this.application.getRunState().show.getFilename();
        String name = file == null ? "show" : file.getName();
        int returnValue = JOptionPane.showConfirmDialog(this, "Save changes to " + name + " first?", "Save confirmation", 1);
        if (returnValue == 1) {
            return true;
        }
        if (returnValue != 0) {
            return false;
        }
        return this.doSave();
    }

    boolean doSave() {
        boolean success;
        if (this.application.getRunState().show.getFilename() == null) {
            return this.doSaveAs();
        }
        File file = this.application.getRunState().show.getFilename();
        File bak = this.addExtension(file, "~");
        if (file.exists() && file.isFile()) {
            if (bak.exists()) {
                bak.delete();
            }
            file.renameTo(bak);
        }
        if (!(success = this.application.saveShow(file))) {
            JOptionPane.showMessageDialog(this, "Error saving " + file, "File Save Error", 0);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSaveAs() {
        File file;
        do {
            int returnVal;
            JFileChooser jFileChooser = this.fileChooser;
            synchronized (jFileChooser) {
                returnVal = this.fileChooser.showSaveDialog(this);
                file = this.fileChooser.getSelectedFile();
            }
            if (returnVal == 0) continue;
            return false;
        } while ((file = this.fixExtension(file, SHOW_EXT)).exists() && 0 != JOptionPane.showConfirmDialog(this, "Overwrite existing file " + file.getName() + "?", "Overwrite confirmation", 0));
        this.application.getRunState().show.setFilename(file);
        return this.doSave();
    }

    private void initJumpDialog() {
        if (!$assertionsDisabled && this.jumpDialog != null) {
            throw new AssertionError();
        }
        this.jumpDialog = new JumpDialog((Frame)this, this.application);
        this.jumpDialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                MainWindow.this.cueSkipToAction.setEnabled(true);
            }

            public void componentShown(ComponentEvent e) {
                MainWindow.this.cueSkipToAction.setEnabled(false);
            }
        });
    }

    private void initThemeDialog() {
        if (!$assertionsDisabled && this.themeDialog != null) {
            throw new AssertionError();
        }
        this.themeDialog = new LAFDialog(this);
        this.themeDialog.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                MainWindow.this.themeAction.setEnabled(true);
            }

            public void componentShown(ComponentEvent e) {
                MainWindow.this.themeAction.setEnabled(false);
            }
        });
    }

    File fixExtension(File file, String extension) {
        if (file.getName().indexOf(46) >= 0) {
            return file;
        }
        if (file.getName().toLowerCase().endsWith(extension.toLowerCase())) {
            return file;
        }
        return this.addExtension(file, extension);
    }

    File addExtension(File file, String extension) {
        return new File(file.getParentFile(), file.getName() + extension);
    }

    static {
        $assertionsDisabled = !MainWindow.class.desiredAssertionStatus();
    }

    static class ActionMapAction
    extends AbstractAction {
        final KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        final String command;

        ActionMapAction(String name, Icon icon, String command) {
            super(name, icon);
            this.command = command;
            this.kfm.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(this){
                private final /* synthetic */ ActionMapAction this$0;
                {
                    this.this$0 = actionMapAction;
                }

                public void propertyChange(PropertyChangeEvent e) {
                    ActionMapAction.access$300(this.this$0);
                }
            });
            this.updateEnable();
        }

        private void updateEnable() {
            JComponent jc = this.lookupFocus();
            this.setEnabled(jc != null && jc.getActionMap().get(this.command) != null);
        }

        public void actionPerformed(ActionEvent e) {
            Action action;
            JComponent jc = this.lookupFocus();
            Action action2 = action = jc == null ? null : jc.getActionMap().get(this.command);
            if (action != null) {
                action.actionPerformed(new ActionEvent(jc, 1001, this.command));
            }
        }

        private JComponent lookupFocus() {
            Component c = this.kfm.getPermanentFocusOwner();
            if (!(c instanceof JComponent)) {
                return null;
            }
            return (JComponent)c;
        }

        static /* synthetic */ void access$300(ActionMapAction x0) {
            x0.updateEnable();
        }
    }

    static class ShowFilter
    extends FileFilter {
        ShowFilter() {
        }

        public String getDescription() {
            return "JChirp Show Files";
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(MainWindow.SHOW_EXT);
        }
    }

    class ThemeAction
    extends AbstractAction {
        ThemeAction() {
            super("Change Theme...", Icons.THEME);
            this.putValue("MnemonicKey", new Integer(72));
            this.putValue("ShortDescription", "Select an application theme");
            this.putValue("LongDescription", "Change the look and feel of the application.");
        }

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.themeDialog == null) {
                MainWindow.this.initThemeDialog();
            }
            MainWindow.this.themeDialog.setVisible(true);
        }
    }

    class RowInsertBeforeAction
    extends AbstractAction {
        RowInsertBeforeAction() {
            super("Insert Before", Icons.CUE_INSERT_BEFORE);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("ShortDescription", "Insert Cue Before");
            this.putValue("LongDescription", "Add a new cue before the current cue.");
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.cueTable.insertBeforeSelectedCues();
        }
    }

    class RowInsertAfterAction
    extends AbstractAction {
        RowInsertAfterAction() {
            super("Insert", Icons.CUE_INSERT_AFTER);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("ShortDescription", "Insert Cue After");
            this.putValue("LongDescription", "Add a new cue after the current cue.");
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.cueTable.insertAfterSelectedCues();
        }
    }

    class RowDeleteAction
    extends AbstractAction {
        RowDeleteAction() {
            super("Remove", Icons.CUE_DELETE);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("ShortDescription", "Delete Cue");
            this.putValue("LongDescription", "Delete the currently-selected cue.");
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.cueTable.deleteSelectedCues();
        }
    }

    class CueSkipToAction
    extends AbstractAction {
        CueSkipToAction() {
            super("Jump To", Icons.CUE_JUMP);
            this.putValue("MnemonicKey", new Integer(74));
            this.putValue("ShortDescription", "Jump To");
            this.putValue("LongDescription", "Jump to a specified cue.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
        }

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.jumpDialog == null) {
                MainWindow.this.initJumpDialog();
            }
            MainWindow.this.jumpDialog.setVisible(true);
        }
    }

    class CueBackAction
    extends AbstractAction {
        CueBackAction() {
            super("Back", Icons.CUE_BACK);
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("ShortDescription", "Back");
            this.putValue("LongDescription", "Go back to the previous cue.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.application.getRunState().back();
        }
    }

    class CueHaltAction
    extends AbstractAction {
        CueHaltAction() {
            super("Halt", Icons.CUE_HALT);
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("ShortDescription", "Halt");
            this.putValue("LongDescription", "Pause the currently-running cue.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.application.getRunState().halt();
        }
    }

    class CueGoAction
    extends AbstractAction {
        CueGoAction() {
            super("Go", Icons.CUE_GO);
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("ShortDescription", "Go");
            this.putValue("LongDescription", "Start the next cue.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.application.getRunState().go();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super("Undo", Icons.UNDO);
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("ShortDescription", "Undo {Action}");
            this.putValue("LongDescription", "Reverse an action.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super("Save As...", Icons.SAVE_AS);
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("ShortDescription", "Save As");
            this.putValue("LongDescription", "Save show to disk with a different name.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.doSaveAs();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save", Icons.SAVE);
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("ShortDescription", "Save");
            this.putValue("LongDescription", "Commit show changes to disk.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.doSave();
        }
    }

    class RevertAction
    extends AbstractAction {
        RevertAction() {
            super("Revert", Icons.REVERT);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("ShortDescription", "Revert");
            this.putValue("LongDescription", "Restore the last saved version of the show.");
        }

        public void actionPerformed(ActionEvent e) {
            Show show = MainWindow.this.application.getRunState().show;
            if (!show.isDirty()) {
                return;
            }
            File file = show.getFilename();
            String name = file == null ? "show" : file.getName();
            int returnValue = JOptionPane.showConfirmDialog(MainWindow.this, "Revert to last-saved version of " + name + "?", "Revert confirmation", 2);
            if (returnValue != 0) {
                return;
            }
            if (!MainWindow.this.application.openShow(file)) {
                JOptionPane.showMessageDialog(MainWindow.this, "Error loading " + file, "File Open Error", 0);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
            super("Redo", Icons.REDO);
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("ShortDescription", "Redo {Action}");
            this.putValue("LongDescription", "Restore an undone transaction.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class PropertiesAction
    extends AbstractAction {
        PropertiesAction() {
            super("Properties", Icons.PROPERTIES);
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("ShortDescription", "Properties of the show");
            this.putValue("LongDescription", "Modify attributes of the current show.");
        }

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.propertiesDialog == null) {
                MainWindow.this.initPropertiesDialog();
            }
            MainWindow.this.propertiesDialog.setVisible(true);
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super("Print...", Icons.PRINT);
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("ShortDescription", "Print to {Current Printer}");
            this.putValue("LongDescription", "Print the cues and patch for this show.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class PreferencesAction
    extends AbstractAction {
        PreferencesAction() {
            super("Preferences", Icons.PREFERENCES);
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("ShortDescription", "Preferences");
            this.putValue("LongDescription", "Modify attributes for the JChirp application.");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class PasteAction
    extends ActionMapAction {
        PasteAction() {
            super("Paste", Icons.PASTE, "paste");
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("ShortDescription", "Paste");
            this.putValue("LongDescription", "Insert data previously placed into a temporary holding area by \"Copy\" or \"Cut\".");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }
    }

    class PageSetupAction
    extends AbstractAction {
        PageSetupAction() {
            super("Page Setup", Icons.PAGE_SETUP);
            this.putValue("MnemonicKey", new Integer(71));
            this.putValue("ShortDescription", "Page Setup");
            this.putValue("LongDescription", "Display an editable list of the properties that affect the printing of this show.");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("Open", Icons.OPEN);
            this.putValue("MnemonicKey", new Integer(79));
            this.putValue("ShortDescription", "Open");
            this.putValue("LongDescription", "Open a show.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            File file;
            if (!MainWindow.this.saveQuestion()) {
                return;
            }
            if (e.getActionCommand() != null && e.getActionCommand().length() > 0) {
                file = new File(e.getActionCommand());
            } else {
                int returnVal;
                JFileChooser jFileChooser = MainWindow.this.fileChooser;
                synchronized (jFileChooser) {
                    returnVal = MainWindow.this.fileChooser.showOpenDialog(MainWindow.this);
                    file = MainWindow.this.fileChooser.getSelectedFile();
                }
                if (returnVal != 0) {
                    return;
                }
            }
            if (!file.exists()) {
                file = MainWindow.this.fixExtension(file, MainWindow.SHOW_EXT);
            }
            if (!file.exists()) {
                JOptionPane.showMessageDialog(MainWindow.this, "File \"" + file + "\" not found.", "File Open Error", 0);
            } else if (!MainWindow.this.application.openShow(file)) {
                JOptionPane.showMessageDialog(MainWindow.this, "Error loading " + file, "File Open Error", 0);
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super("New", Icons.NEW);
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("ShortDescription", "New");
            this.putValue("LongDescription", "Create a new show.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }

        public void actionPerformed(ActionEvent e) {
            if (!MainWindow.this.saveQuestion()) {
                return;
            }
            MainWindow.this.application.newShow();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit", Icons.EXIT);
            this.putValue("MnemonicKey", new Integer(88));
            this.putValue("ShortDescription", "Exit");
            this.putValue("LongDescription", "Exit the program.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, 2));
        }

        public void actionPerformed(ActionEvent e) {
            if (!MainWindow.this.saveQuestion()) {
                return;
            }
            if (JOptionPane.showConfirmDialog(MainWindow.this, "Are you sure you want to exit?", "Exit confirmation", 0) != 0) {
                return;
            }
            System.exit(0);
        }
    }

    class DeleteAction
    extends ActionMapAction {
        DeleteAction() {
            super("Delete", Icons.DELETE, "delete-previous");
            this.putValue("MnemonicKey", new Integer(68));
            this.putValue("ShortDescription", "Delete");
            this.putValue("LongDescription", "Remove the selected item.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }
    }

    class CutAction
    extends ActionMapAction {
        CutAction() {
            super("Cut", Icons.CUT, "cut");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("ShortDescription", "Cut");
            this.putValue("LongDescription", "Remove the selected item from its current context.  It is now available to be pasted elsewhere.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }
    }

    class CopyAction
    extends ActionMapAction {
        CopyAction() {
            super("Copy", Icons.COPY, "copy");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("ShortDescription", "Copy");
            this.putValue("LongDescription", "Create a duplicate of the selected object.  This duplicate is now available to be pasted elsewhere.");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About JChirp", Icons.ABOUT);
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("ShortDescription", "About JChirp");
            this.putValue("LongDescription", "Provide information regarding the application.");
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(MainWindow.this, "JChirp 0.0\nby C. Scott Ananian\ncananian@chirpcheap.com\nhttp://chirpcheap.com", "JChirp: About", 1, Icons.MAIN_WINDOW);
        }
    }
}

