/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.CueComboBox;
import com.chirpcheap.jchirp.GUI.OKDialog;
import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.Cue;
import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.RunState;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JumpDialog
extends OKDialog {
    final Application application;
    final CueComboBox ccb;

    JumpDialog(Frame parent, final Application application) {
        super(parent, "Jump to Cue...", false, false);
        this.application = application;
        JPanel contentPane = this.getContentPane();
        GridBagLayout gridBag = new GridBagLayout();
        contentPane.setLayout(gridBag);
        JLabel label = new JLabel("Jump to Cue: ");
        this.ccb = new CueComboBox(application, false, false);
        this.ccb.setEditable(true);
        this.addLabelTextRows(new JLabel[]{label}, new JComponent[]{this.ccb}, null, gridBag, contentPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Cue cue = application.getRunState().getNextCue();
                if (cue != null) {
                    JumpDialog.this.ccb.setSelectedItem(cue.getCueNumber());
                }
            }
        });
        this.pack();
    }

    protected ActionListener okListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JumpDialog.this.setVisible(false);
                RunState runState = JumpDialog.this.application.getRunState();
                runState.setNextCue((CueNumber)JumpDialog.this.ccb.getSelectedItem());
                runState.go();
            }
        };
    }

    protected ActionListener cancelListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JumpDialog.this.setVisible(false);
            }
        };
    }
}

