/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.CueComboBox;
import com.chirpcheap.jchirp.GUI.Icons;
import com.chirpcheap.jchirp.GUI.JTimeLabel;
import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.Cue;
import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.RunState;
import com.chirpcheap.jchirp.Model.Show;
import com.chirpcheap.jchirp.swing.EqualHeightLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;

public class JStatusBar
extends JPanel {
    final Application application;
    final CueSelectPanel cueSelectPanel;
    final IndicatorPanel indicatorPanel;
    final JLabel messageLabel;
    public final MouseListener mouseListener;

    JStatusBar(Application application) {
        super(new BorderLayout());
        this.application = application;
        this.add((Component)new JSeparator(), "North");
        JPanel rhs = new JPanel(new BorderLayout());
        this.add((Component)rhs, "Center");
        this.cueSelectPanel = new CueSelectPanel();
        this.add((Component)this.cueSelectPanel, "West");
        this.indicatorPanel = new IndicatorPanel();
        rhs.add((Component)this.indicatorPanel, "East");
        this.messageLabel = new JLabel("Chirp!  Cheap!", 0);
        this.messageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5), new SoftBevelBorder(1)));
        this.messageLabel.setEnabled(false);
        rhs.add((Component)this.messageLabel, "Center");
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                this.process(evt, true);
            }

            public void mouseExited(MouseEvent evt) {
                this.process(evt, false);
            }

            void process(MouseEvent evt, boolean isEnter) {
                if (evt.getSource() instanceof AbstractButton) {
                    JStatusBar.this.updateStatus((AbstractButton)evt.getSource(), isEnter);
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() instanceof AbstractButton) {
                    JStatusBar.this.updateStatus((AbstractButton)evt.getOldValue(), false);
                }
                if (evt.getNewValue() instanceof AbstractButton) {
                    JStatusBar.this.updateStatus((AbstractButton)evt.getNewValue(), true);
                }
            }
        });
    }

    private void updateStatus(AbstractButton button, boolean isEnter) {
        Action action = button.getAction();
        if (action != null) {
            this.updateStatus(action, isEnter);
        }
    }

    private void updateStatus(Action action, boolean isEnter) {
        String message = (String)action.getValue("LongDescription");
        this.setStatusMessage(isEnter ? message : null, action.isEnabled());
    }

    public void setStatusMessage(String message, boolean isEnabled) {
        if (message == null) {
            this.messageLabel.setText("Chirp!  Cheap!");
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setEnabled(false);
        } else {
            this.messageLabel.setText(message);
            this.messageLabel.setHorizontalAlignment(2);
            this.messageLabel.setEnabled(isEnabled);
        }
    }

    static CueTime totalCueTime(Cue cue) {
        CueTime delayTime;
        CueTime downTime;
        CueTime totalTime;
        CueTime upTime = cue.getUpTime();
        if (upTime.compareTo(totalTime = (downTime = cue.getDownTime()).add(delayTime = cue.getDelayTime())) > 0) {
            totalTime = upTime;
        }
        return totalTime;
    }

    class IndicatorPanel
    extends JPanel {
        final JLabel dirtyLabel;
        final JLabel lockLabel;
        final Show.Listener showListener;

        IndicatorPanel() {
            super(new EqualHeightLayout(5));
            this.showListener = new Show.Adapter(this){
                private final /* synthetic */ IndicatorPanel this$1;
                {
                    this.this$1 = indicatorPanel;
                }

                private Show getShow() {
                    return IndicatorPanel.access$300((IndicatorPanel)this.this$1).application.getRunState().show;
                }

                public void showAncestorChanged(ChangeEvent event) {
                    this.getShow().addShowListener(this);
                    this.showDirtyChanged(event);
                    this.showEditableChanged(event);
                }

                public void showDirtyChanged(ChangeEvent event) {
                    boolean dirty = this.getShow().isDirty();
                    if (Icons.DIRTY != null && Icons.NOT_DIRTY != null) {
                        this.this$1.dirtyLabel.setText(null);
                        this.this$1.dirtyLabel.setIcon(dirty ? Icons.DIRTY : Icons.NOT_DIRTY);
                    } else {
                        this.this$1.dirtyLabel.setText(dirty ? "!" : " ");
                        this.this$1.dirtyLabel.setIcon(null);
                    }
                    this.this$1.dirtyLabel.setToolTipText(dirty ? "There are unsaved changes to the show." : null);
                }

                public void showEditableChanged(ChangeEvent event) {
                    boolean editable = this.getShow().isEditable();
                    if (Icons.UNLOCKED != null && Icons.LOCKED != null) {
                        this.this$1.lockLabel.setText(null);
                        this.this$1.lockLabel.setIcon(editable ? Icons.UNLOCKED : Icons.LOCKED);
                    } else {
                        this.this$1.lockLabel.setText(editable ? "      " : "LOCKED");
                        this.this$1.lockLabel.setIcon(null);
                    }
                    this.this$1.lockLabel.setToolTipText(editable ? "Show is unlocked: changes are allowed." : "Show is locked: changes are not allowed.");
                    this.this$1.lockLabel.setEnabled(!editable);
                }
            };
            this.dirtyLabel = new JLabel("*", 0);
            JTimeLabel timeLabel = new JTimeLabel(0);
            this.lockLabel = new JLabel(Icons.LOCKED);
            this.add(timeLabel);
            this.add(this.lockLabel);
            this.add(this.dirtyLabel);
            this.showListener.showAncestorChanged(null);
        }

        static /* synthetic */ JStatusBar access$300(IndicatorPanel x0) {
            return x0.JStatusBar.this;
        }
    }

    abstract class CueInfoListener
    implements RunState.Listener {
        Cue oldCurCue;
        Cue oldNextCue;
        final Cue.Listener cueListener = new Cue.Adapter(this){
            private final /* synthetic */ CueInfoListener this$1;
            {
                this.this$1 = cueInfoListener;
            }

            public void cueInfoChanged(Cue.ChangeEvent event) {
                this.this$1.update();
            }
        };

        CueInfoListener() {
            this.runStateAncestorChanged(null);
        }

        protected RunState getRunState() {
            return JStatusBar.this.application.getRunState();
        }

        private void updateListener() {
            if (this.oldCurCue != null) {
                this.oldCurCue.removeCueListener(this.cueListener);
            }
            if (this.oldNextCue != null) {
                this.oldNextCue.removeCueListener(this.cueListener);
            }
            RunState runState = this.getRunState();
            this.oldCurCue = runState.getCurrentCue();
            if (this.oldCurCue != null) {
                this.oldCurCue.addCueListener(this.cueListener);
            }
            this.oldNextCue = runState.getNextCue();
            if (this.oldNextCue != null) {
                this.oldNextCue.addCueListener(this.cueListener);
            }
        }

        public void runStateAncestorChanged(ChangeEvent event) {
            this.getRunState().addRunStateListener(this);
            this.runStateFaderChanged(event);
        }

        public void runStateFaderChanged(ChangeEvent event) {
            this.updateListener();
            this.update();
        }

        public void runStateCueProgress(ChangeEvent event) {
            this.update();
        }

        protected abstract void update();
    }

    class NextCuePanel
    extends JPanel {
        final JComboBox nextCueCombo;
        final JLabel nextTimeLabel;

        NextCuePanel() {
            super(new EqualHeightLayout(5));
            JLabel label = new JLabel("Next Cue:", 4);
            this.nextCueCombo = new CueComboBox(JStatusBar.this.application, false, false);
            this.nextCueCombo.setEditable(true);
            this.nextTimeLabel = new JLabel("(0:00)");
            this.add(label);
            this.add(this.nextCueCombo);
            this.add(this.nextTimeLabel);
            new CueInfoListener(){
                private final /* synthetic */ JStatusBar val$this$0;
                private final /* synthetic */ NextCuePanel this$1;
                {
                    this.this$1 = nextCuePanel;
                    this.val$this$0 = jStatusBar;
                }

                public void update() {
                    Cue nextCue = this.getRunState().getNextCue();
                    if (nextCue == null) {
                        this.this$1.nextCueCombo.setSelectedItem(null);
                        this.this$1.nextTimeLabel.setText("(-:--)");
                    } else {
                        CueNumber cn = nextCue.getCueNumber();
                        if (!cn.equals(this.this$1.nextCueCombo.getSelectedItem())) {
                            this.this$1.nextCueCombo.setSelectedItem(cn);
                        }
                        String timeStr = JStatusBar.totalCueTime(nextCue).toString(false);
                        timeStr = new StringBuffer().append("(").append(timeStr).append(")").toString();
                        if (!timeStr.equals(this.this$1.nextTimeLabel.getText())) {
                            this.this$1.nextTimeLabel.setText(timeStr);
                        }
                    }
                }
            };
            this.nextCueCombo.addActionListener(new ActionListener(){
                private final /* synthetic */ JStatusBar val$this$0;
                private final /* synthetic */ NextCuePanel this$1;
                {
                    this.this$1 = nextCuePanel;
                    this.val$this$0 = jStatusBar;
                }

                public void actionPerformed(ActionEvent e) {
                    CueNumber cn = (CueNumber)this.this$1.nextCueCombo.getSelectedItem();
                    RunState runState = NextCuePanel.access$200((NextCuePanel)this.this$1).application.getRunState();
                    runState.setNextCue(cn);
                }
            });
        }

        static /* synthetic */ JStatusBar access$200(NextCuePanel x0) {
            return x0.JStatusBar.this;
        }
    }

    class CurrentCuePanel
    extends JPanel {
        final JLabel currentCueLabel;
        final JLabel currentTimeLabel;

        CurrentCuePanel() {
            super(new EqualHeightLayout(5));
            JLabel label = new JLabel("Current Cue:", 4);
            this.currentCueLabel = new JLabel("1");
            this.currentTimeLabel = new JLabel("(0:00)");
            this.add(label);
            this.add(this.currentCueLabel);
            this.add(this.currentTimeLabel);
            new CueInfoListener(){
                private final /* synthetic */ JStatusBar val$this$0;
                private final /* synthetic */ CurrentCuePanel this$1;
                {
                    this.this$1 = currentCuePanel;
                    this.val$this$0 = jStatusBar;
                }

                public void update() {
                    Cue currentCue = this.getRunState().getCurrentCue();
                    if (currentCue == null) {
                        this.this$1.currentCueLabel.setText("--");
                        this.this$1.currentTimeLabel.setText("(-:--)");
                    } else {
                        String cueStr = currentCue.getCueNumber().toString();
                        if (!cueStr.equals(this.this$1.currentCueLabel.getText())) {
                            this.this$1.currentCueLabel.setText(cueStr);
                        }
                        CueTime totalTime = JStatusBar.totalCueTime(currentCue);
                        CueTime timeLeft = totalTime.scale(1.0f - this.getRunState().getProgress());
                        String timeStr = new StringBuffer().append("(").append(timeLeft.toString(false)).append(")").toString();
                        if (!timeStr.equals(this.this$1.currentTimeLabel.getText())) {
                            this.this$1.currentTimeLabel.setText(timeStr);
                        }
                    }
                }
            };
        }

        static /* synthetic */ JStatusBar access$100(CurrentCuePanel x0) {
            return x0.JStatusBar.this;
        }
    }

    class CueSelectPanel
    extends JPanel {
        CueSelectPanel() {
            super(new BorderLayout());
            this.add((Component)new JSeparator(1), "Center");
            this.add((Component)new CurrentCuePanel(), "West");
            this.add((Component)new NextCuePanel(), "East");
        }
    }
}

