/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.Icons;
import com.chirpcheap.jchirp.GUI.JMasterSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;

public class JStageComponent
extends JPanel {
    JStageComponent() {
        super(new BorderLayout());
        LevelsPanel levelsPanel = new LevelsPanel();
        JScrollPane scrollPane = new JScrollPane(levelsPanel);
        levelsPanel.setViewport(scrollPane.getViewport());
        this.add((Component)scrollPane, "Center");
        ButtonBar buttonBar = new ButtonBar();
        this.add((Component)buttonBar, "South");
        JMasterSlider masterSlider = new JMasterSlider();
        this.add((Component)masterSlider, "East");
    }

    class ChannelBox
    extends Box {
        ChannelBox(int start, int num) {
            super(0);
            ChannelBox.createHorizontalStrut(6);
            for (int i = 0; i < num; ++i) {
                JPanel lvl = new JPanel();
                lvl.add(new JLabel(Integer.toString(55), 0));
                lvl.setBorder(BorderFactory.createTitledBorder(Integer.toString(start + i)));
                this.add(lvl);
            }
            ChannelBox.createHorizontalStrut(6);
        }
    }

    static class MyFlowLayout
    extends FlowLayout {
        int widthConstraint = 0;

        MyFlowLayout(int align) {
            super(align);
        }

        public void setWidthConstraint(int width) {
            this.widthConstraint = width;
        }

        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, false);
        }

        public Dimension minimumLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean isMin) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                boolean firstVisibleComponent = true;
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                int x = 0;
                int y = 0;
                int rowh = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Dimension d;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension dimension = d = isMin ? m.getMinimumSize() : m.getPreferredSize();
                    if (x == 0 || this.widthConstraint == 0 || x + d.width <= this.widthConstraint) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowh = Math.max(rowh, d.height);
                    } else {
                        x = d.width;
                        y += vgap + rowh;
                        rowh = d.height;
                    }
                    dim.width = Math.max(dim.width, x);
                    dim.height = Math.max(dim.height, y + rowh);
                }
                Insets insets = target.getInsets();
                dim.width += insets.left + insets.right + hgap * 2;
                dim.height += insets.top + insets.bottom + vgap * 2;
                return dim;
            }
        }
    }

    class LevelsPanel
    extends JPanel {
        MyFlowLayout layout;
        JViewport viewport;

        LevelsPanel() {
            this(new MyFlowLayout(0));
        }

        private LevelsPanel(MyFlowLayout layout) {
            super(layout);
            int MAX_CHANNELS = 48;
            int BLOCK_SIZE = 6;
            for (int i = 1; i <= 48; i += 6) {
                this.add(new ChannelBox(i, Math.min(6, 49 - i)));
            }
            this.layout = layout;
        }

        void setViewport(JViewport viewport) {
            this.viewport = viewport;
        }

        public Dimension getPreferredSize() {
            if (this.viewport != null) {
                this.layout.setWidthConstraint(this.viewport.getWidth());
            }
            return super.getPreferredSize();
        }
    }

    class ButtonBar
    extends JPanel {
        ButtonBar() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel lhs = new JPanel(new GridBagLayout());
            JPanel rhs = new JPanel(new GridBagLayout());
            this.add((Component)lhs, "West");
            this.add((Component)rhs, "East");
            JComboBox<String> channelLabel = new JComboBox<String>(new String[]{"Channel", "Dimmer"});
            JSpinner channelSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 120, 1));
            JLabel levelLabel = new JLabel("Level:");
            JSpinner levelSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
            JButton captureButton = new JButton("Capture", Icons.PLUS);
            JButton clearButton = new JButton("Clear", Icons.MINUS);
            JButton recordButton = new JButton("Record Stage As Cue", Icons.CUE_RECORD);
            JButton clearAllButton = new JButton("Clear All Captured", Icons.CLEAR);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 5);
            lhs.add(channelLabel, c);
            lhs.add((Component)channelSpinner, c);
            lhs.add((Component)levelLabel, c);
            lhs.add((Component)levelSpinner, c);
            lhs.add((Component)captureButton, c);
            lhs.add((Component)clearButton, c);
            c.anchor = 13;
            c.insets = new Insets(0, 15, 0, 0);
            rhs.add((Component)recordButton, c);
            rhs.add((Component)clearAllButton, c);
        }
    }
}

