/*
 * Decompiled with CFR 0.152.
 */
package com.chirpcheap.jchirp.GUI;

import com.chirpcheap.jchirp.GUI.JCueTable;
import com.chirpcheap.jchirp.GUI.MinMaxIntegerFormat;
import com.chirpcheap.jchirp.GUI.OKDialog;
import com.chirpcheap.jchirp.Model.Application;
import com.chirpcheap.jchirp.Model.Cue;
import com.chirpcheap.jchirp.Model.CueNumber;
import com.chirpcheap.jchirp.Model.CueTime;
import com.chirpcheap.jchirp.Model.Patch;
import com.chirpcheap.jchirp.Model.Show;
import com.chirpcheap.jchirp.swing.CCAbstractTableModel;
import com.chirpcheap.jchirp.swing.CCFormattedTextField;
import com.chirpcheap.jchirp.swing.CCTable;
import com.chirpcheap.jchirp.swing.CommitListener;
import com.chirpcheap.jchirp.swing.FormattedCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.Format;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class JCueTable
extends CCTable {
    final JCueTableModel model = (JCueTableModel)this.getModel();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$chirpcheap$jchirp$GUI$JCueTable;

    JCueTable(Frame parent, Application application) {
        super(new JCueTableModel(application));
        this.setAutoResizeMode(0);
        this.setSurrendersFocusOnKeystroke(true);
        this.setDefaultEditor(Short.class, new FormattedCellEditor(new CCFormattedTextField(new MinMaxIntegerFormat(0L, 100L))){

            public Object getCellEditorValue() {
                return new Short(((Number)super.getCellEditorValue()).shortValue());
            }
        });
        this.setDefaultEditor(CueNumber.class, new FormattedCellEditor(new CCFormattedTextField(new CueNumber.Format())));
        this.setDefaultEditor(TimeAggregate.class, new TimeAggregateEditor(parent));
        this.setDefaultEditor(LinkAggregate.class, new LinkAggregateEditor(parent));
        this.setSelectionMode(1);
        this.setCellSelectionEnabled(true);
        this.setDragEnabled(true);
    }

    public void deleteSelectedCues() {
        Show show = this.model.application.getRunState().show;
        int[] selRows = this.getSelectedRows();
        for (int i = 0; i < selRows.length; ++i) {
            CueNumber cn = (CueNumber)this.model.getValueAt(selRows[i], 1);
            if (cn == null) continue;
            show.removeCue(cn);
        }
    }

    public void insertAfterSelectedCues() {
        throw new RuntimeException("Unimplemented.");
    }

    public void insertBeforeSelectedCues() {
        throw new RuntimeException("Unimplemented.");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DialogEditor<T>
    extends AbstractCellEditor
    implements TableCellEditor {
        final Frame frameParent;
        final JButton button;
        final MyDialog<T> dialog;

        private void setButtonText() {
            this.button.setText(this.dialog.value == null ? "" : this.dialog.value.toString());
        }

        DialogEditor(Frame frameParent) {
            this(frameParent, 2);
        }

        DialogEditor(Frame frameParent, int button_alignment) {
            this.frameParent = frameParent;
            this.button = new JButton();
            this.button.setHorizontalAlignment(button_alignment);
            this.button.setBackground(Color.white);
            this.button.setBorderPainted(false);
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ DialogEditor this$0;
                {
                    this.this$0 = dialogEditor;
                }

                public void actionPerformed(ActionEvent e) {
                    DialogEditor.access$000(this.this$0);
                    this.this$0.dialog.setLocationRelativeTo(this.this$0.button);
                    this.this$0.dialog.setVisible(true);
                    this.this$0.dialog.setLocationRelativeTo(this.this$0.button);
                }
            });
            this.dialog = this.createDialog(this.button);
        }

        abstract MyDialog<T> createDialog(Component var1);

        public T getCellEditorValue() {
            return this.dialog.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.cancelCellEditing();
            this.dialog.setValue(value);
            this.setButtonText();
            return this.button;
        }

        @Override
        public void cancelCellEditing() {
            this.dialog.setVisible(false);
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            this.dialog.setVisible(false);
            return super.stopCellEditing();
        }

        static /* synthetic */ void access$000(DialogEditor x0) {
            x0.setButtonText();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MyDialog<T>
    extends OKDialog {
        DialogEditor<T> editor;
        T value;
        JLabel[] labels;
        CCFormattedTextField[] fields;
        static final /* synthetic */ boolean $assertionsDisabled;

        abstract void setValue(Object var1);

        abstract Object getField(int var1);

        abstract void setField(int var1, Object var2);

        MyDialog(DialogEditor<T> editor, Component parent, String title, String[] fieldNames, Format[] fieldFormats) {
            super(editor.frameParent, title, false, true);
            this.editor = editor;
            if (!$assertionsDisabled && fieldNames.length != fieldFormats.length) {
                throw new AssertionError();
            }
            JPanel contentPane = this.getContentPane();
            GridBagLayout gridbag = new GridBagLayout();
            contentPane.setLayout(gridbag);
            this.labels = new JLabel[fieldNames.length];
            this.fields = new CCFormattedTextField[fieldNames.length];
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i] = new JLabel(new StringBuffer().append(fieldNames[i]).append(": ").toString());
                this.fields[i] = new CCFormattedTextField(fieldFormats[i]);
                this.fields[i].setDragEnabled(true);
            }
            this.addLabelTextRows(this.labels, this.fields, null, gridbag, contentPane);
            CommitListener cl = new CommitListener(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = myDialog;
                }

                public void valueCommitted(ChangeEvent e) {
                    this.this$0.resetAction.setEnabled(true);
                }
            };
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].addCommitListener(cl);
            }
            this.resetAction.setEnabled(false);
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = myDialog;
                }

                public void componentShown(ComponentEvent e) {
                    this.this$0.resetAction.actionPerformed(null);
                }
            });
            this.pack();
        }

        @Override
        protected ActionListener cancelListener() {
            return new ActionListener(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = myDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.setVisible(false);
                    this.this$0.editor.cancelCellEditing();
                }
            };
        }

        @Override
        protected ActionListener okListener() {
            return new ActionListener(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = myDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < this.this$0.fields.length; ++i) {
                        this.this$0.setField(i, this.this$0.fields[i].getValue());
                    }
                    this.this$0.setVisible(false);
                    this.this$0.editor.stopCellEditing();
                }
            };
        }

        @Override
        protected ActionListener resetListener() {
            return new ActionListener(this){
                private final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = myDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < this.this$0.fields.length; ++i) {
                        this.this$0.fields[i].setValue(this.this$0.getField(i));
                    }
                    this.this$0.resetAction.setEnabled(false);
                }
            };
        }

        static {
            $assertionsDisabled = !(class$com$chirpcheap$jchirp$GUI$JCueTable == null ? (class$com$chirpcheap$jchirp$GUI$JCueTable = JCueTable.class$("com.chirpcheap.jchirp.GUI.JCueTable")) : class$com$chirpcheap$jchirp$GUI$JCueTable).desiredAssertionStatus();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkAggregateEditor
    extends DialogEditor<LinkAggregate> {
        LinkAggregateEditor(Frame parent) {
            super(parent);
        }

        @Override
        MyDialog<LinkAggregate> createDialog(Component c) {
            String[] fieldNames = new String[]{"Link to Cue", "Link After"};
            Format[] fieldFormats = new Format[]{new CueNumber.Format(true), new CueTime.Format(false)};
            return new MyDialog<LinkAggregate>(this, (DialogEditor<LinkAggregate>)this, c, "Edit Link", fieldNames, fieldFormats){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ LinkAggregateEditor this$0;
                {
                    this.this$0 = linkAggregateEditor;
                    super(x0, x1, x2, x3, x4);
                }

                void setValue(Object o) {
                    this.value = (LinkAggregate)o;
                }

                Object getField(int which) {
                    switch (which) {
                        case 0: {
                            return ((LinkAggregate)this.value).linkNumber;
                        }
                        case 1: {
                            return ((LinkAggregate)this.value).linkTime;
                        }
                    }
                    throw new RuntimeException("bad field");
                }

                void setField(int which, Object o) {
                    switch (which) {
                        case 0: {
                            ((LinkAggregate)this.value).linkNumber = (CueNumber)o;
                            return;
                        }
                        case 1: {
                            ((LinkAggregate)this.value).linkTime = (CueTime)o;
                            return;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }

                static {
                    $assertionsDisabled = !(class$com$chirpcheap$jchirp$GUI$JCueTable == null ? (class$com$chirpcheap$jchirp$GUI$JCueTable = JCueTable.class$("com.chirpcheap.jchirp.GUI.JCueTable")) : class$com$chirpcheap$jchirp$GUI$JCueTable).desiredAssertionStatus();
                }
            };
        }

        @Override
        public /* synthetic */ Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    static class LinkAggregate {
        CueNumber linkNumber;
        CueTime linkTime;

        LinkAggregate(Cue cue) {
            this(cue.getLinkNumber(), cue.getLinkNumber() == null && cue.getUpTime().equals(cue.getDownTime()) ? cue.getUpTime() : cue.getLinkTime());
        }

        LinkAggregate(CueNumber linkNumber, CueTime linkTime) {
            this.linkNumber = linkNumber;
            this.linkTime = linkTime;
        }

        public String toString() {
            if (this.linkNumber == null) {
                return "";
            }
            return this.linkNumber.toString() + " (" + this.linkTime.toString(false) + ")";
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeAggregateEditor
    extends DialogEditor<TimeAggregate> {
        TimeAggregateEditor(Frame parent) {
            super(parent);
        }

        @Override
        MyDialog<TimeAggregate> createDialog(Component c) {
            String[] fieldNames = new String[]{"Up Time", "Down Time", "Delay Time"};
            CueTime.Format cueTimeFormat = new CueTime.Format(false);
            Format[] fieldFormats = new Format[]{cueTimeFormat, cueTimeFormat, cueTimeFormat};
            return new MyDialog<TimeAggregate>(this, (DialogEditor<TimeAggregate>)this, c, "Edit Cue Time", fieldNames, fieldFormats){
                boolean sameUpDown;
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ TimeAggregateEditor this$0;
                {
                    this.this$0 = timeAggregateEditor;
                    super(x0, x1, x2, x3, x4);
                    this.fields[0].addCommitListener(new CommitListener(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void valueCommitted(ChangeEvent e) {
                            if (this.this$1.sameUpDown) {
                                this.this$1.fields[1].setValue(this.this$1.fields[0].getValue());
                            }
                            this.this$1.sameUpDown = this.this$1.fields[0].getValue().equals(this.this$1.fields[1].getValue());
                        }
                    });
                    this.fields[1].addCommitListener(new CommitListener(this){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void valueCommitted(ChangeEvent e) {
                            this.this$1.sameUpDown = this.this$1.fields[0].getValue().equals(this.this$1.fields[1].getValue());
                        }
                    });
                }

                void setValue(Object o) {
                    this.value = (TimeAggregate)o;
                    this.sameUpDown = ((TimeAggregate)this.value).upTime.equals(((TimeAggregate)this.value).downTime);
                }

                Object getField(int which) {
                    switch (which) {
                        case 0: {
                            return ((TimeAggregate)this.value).upTime;
                        }
                        case 1: {
                            return ((TimeAggregate)this.value).downTime;
                        }
                        case 2: {
                            return ((TimeAggregate)this.value).delayTime;
                        }
                    }
                    throw new RuntimeException("bad field");
                }

                void setField(int which, Object o) {
                    switch (which) {
                        case 0: {
                            ((TimeAggregate)this.value).upTime = (CueTime)o;
                            return;
                        }
                        case 1: {
                            ((TimeAggregate)this.value).downTime = (CueTime)o;
                            return;
                        }
                        case 2: {
                            ((TimeAggregate)this.value).delayTime = (CueTime)o;
                            return;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }

                static {
                    $assertionsDisabled = !(class$com$chirpcheap$jchirp$GUI$JCueTable == null ? (class$com$chirpcheap$jchirp$GUI$JCueTable = JCueTable.class$("com.chirpcheap.jchirp.GUI.JCueTable")) : class$com$chirpcheap$jchirp$GUI$JCueTable).desiredAssertionStatus();
                }
            };
        }

        @Override
        public /* synthetic */ Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    static class TimeAggregate {
        CueTime upTime;
        CueTime downTime;
        CueTime delayTime;

        TimeAggregate(Cue cue) {
            this(cue.getUpTime(), cue.getDownTime(), cue.getDelayTime());
        }

        TimeAggregate(CueTime upTime, CueTime downTime, CueTime delayTime) {
            this.upTime = upTime;
            this.downTime = downTime;
            this.delayTime = delayTime;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.upTime.toString(true));
            if (!this.upTime.equals(this.downTime)) {
                sb.append('u');
                sb.append('/');
                sb.append(this.downTime.toString(true));
                sb.append('d');
            }
            if (!this.delayTime.equals(CueTime.ZERO)) {
                if (!this.upTime.equals(this.downTime)) {
                    sb.append('/');
                }
                sb.append('w');
                sb.append(this.delayTime.toString(true));
            }
            return sb.toString();
        }
    }

    static class JCueTableModel
    extends CCAbstractTableModel {
        final Application application;
        private static final int NONCHANNEL_COLUMNS = 4;

        JCueTableModel(Application application) {
            this.application = application;
            new Show.Adapter(this){
                private final /* synthetic */ JCueTableModel this$0;
                {
                    this.this$0 = jCueTableModel;
                }

                public void showAncestorChanged(ChangeEvent event) {
                    this.this$0.application.getRunState().show.addShowListener(this);
                    this.this$0.fireTableStructureChanged();
                }

                public void showCueModified(Show.CueListChangeEvent event) {
                    Cue.ChangeEvent ce = event.getChangeEvent();
                    int row = event.getCueIndex();
                    switch (ce.getType()) {
                        case 0: {
                            this.this$0.fireTableCellUpdated(row, 0);
                            return;
                        }
                        case 1: {
                            this.this$0.fireTableCellUpdated(row, 1);
                            return;
                        }
                        case 2: {
                            this.this$0.fireTableCellUpdated(row, 2);
                            this.this$0.fireTableCellUpdated(row, 3);
                            return;
                        }
                        case 3: {
                            this.this$0.fireTableCellUpdated(row, 3);
                            return;
                        }
                        case 4: {
                            if (ce.getStartChannel() != ce.getEndChannel()) break;
                            this.this$0.fireTableCellUpdated(row, 4 + ce.getStartChannel());
                            return;
                        }
                    }
                    this.this$0.fireTableRowsUpdated(row, row);
                }

                public void showCueAdded(Show.CueListChangeEvent event) {
                    int row = event.getCueIndex();
                    this.this$0.fireTableRowsInserted(row, row);
                }

                public void showCueRemoved(Show.CueListChangeEvent event) {
                    int row = event.getCueIndex();
                    this.this$0.fireTableRowsDeleted(row, row);
                }

                public void showCueRenumbered(Show.CueListChangeEvent event) {
                    int newRow = event.getCueIndex();
                    int oldRow = event.getOldCueIndex();
                    this.this$0.fireTableRowsMoved(oldRow, oldRow, newRow);
                }
            }.showAncestorChanged(null);
            new Patch.Adapter(this){
                private final /* synthetic */ JCueTableModel this$0;
                {
                    this.this$0 = jCueTableModel;
                }

                public void patchAncestorChanged(ChangeEvent event) {
                    this.this$0.application.getRunState().show.patch.addPatchListener(this);
                    this.this$0.fireTableStructureChanged();
                }

                public void patchNumChannelsChanged(ChangeEvent event) {
                    this.this$0.fireTableStructureChanged();
                }
            }.patchAncestorChanged(null);
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Notes";
                }
                case 1: {
                    return "Cue #";
                }
                case 2: {
                    return "Time (s)";
                }
                case 3: {
                    return "Link";
                }
            }
            int chan = col - 4;
            Patch patch = this.application.getRunState().show.patch;
            return "" + (chan + 1);
        }

        public int getColumnCount() {
            return this.application.getRunState().show.patch.getNumChannels() + 4;
        }

        public int getRowCount() {
            return this.application.getRunState().show.getNumCues();
        }

        public boolean isCellEditable(int row, int col) {
            return this.application.getRunState().show.isEditable();
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = JCueTable.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$com$chirpcheap$jchirp$Model$CueNumber == null ? (class$com$chirpcheap$jchirp$Model$CueNumber = JCueTable.class$("com.chirpcheap.jchirp.Model.CueNumber")) : class$com$chirpcheap$jchirp$Model$CueNumber;
                }
                case 2: {
                    return class$com$chirpcheap$jchirp$GUI$JCueTable$TimeAggregate == null ? (class$com$chirpcheap$jchirp$GUI$JCueTable$TimeAggregate = JCueTable.class$("com.chirpcheap.jchirp.GUI.JCueTable$TimeAggregate")) : class$com$chirpcheap$jchirp$GUI$JCueTable$TimeAggregate;
                }
                case 3: {
                    return class$com$chirpcheap$jchirp$GUI$JCueTable$LinkAggregate == null ? (class$com$chirpcheap$jchirp$GUI$JCueTable$LinkAggregate = JCueTable.class$("com.chirpcheap.jchirp.GUI.JCueTable$LinkAggregate")) : class$com$chirpcheap$jchirp$GUI$JCueTable$LinkAggregate;
                }
            }
            return class$java$lang$Short == null ? (class$java$lang$Short = JCueTable.class$("java.lang.Short")) : class$java$lang$Short;
        }

        public Object getValueAt(int row, int col) {
            Cue cue = this.application.getRunState().show.getCue(row);
            switch (col) {
                case 0: {
                    return cue.getNotes();
                }
                case 1: {
                    return cue.getCueNumber();
                }
                case 2: {
                    return new TimeAggregate(cue);
                }
                case 3: {
                    return new LinkAggregate(cue);
                }
            }
            int chan = col - 4;
            return new Short(cue.getLevel(chan));
        }

        public void setValueAt(Object value, int row, int col) {
            Show show = this.application.getRunState().show;
            Cue cue = show.getCue(row);
            switch (col) {
                case 0: {
                    cue.setNotes((String)value);
                    return;
                }
                case 1: {
                    if (show.getCue((CueNumber)value) == null) {
                        show.renumberCue(cue.getCueNumber(), (CueNumber)value);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    return;
                }
                case 2: {
                    boolean locked = cue.getUpTime().equals(cue.getDownTime()) && cue.getUpTime().equals(cue.getLinkTime()) && cue.getDelayTime().equals(CueTime.ZERO);
                    TimeAggregate ta = (TimeAggregate)value;
                    cue.setUpTime(ta.upTime);
                    cue.setDownTime(ta.downTime);
                    cue.setDelayTime(ta.delayTime);
                    if (locked && cue.getUpTime().equals(cue.getDownTime()) && cue.getDelayTime().equals(CueTime.ZERO)) {
                        cue.setLinkTime(cue.getUpTime());
                    }
                    return;
                }
                case 3: {
                    LinkAggregate la = (LinkAggregate)value;
                    cue.setLinkNumber(la.linkNumber);
                    cue.setLinkTime(la.linkTime);
                    return;
                }
            }
            int chan = col - 4;
            cue.setLevel(chan, (Short)value);
        }
    }
}

